:: http://zone54.com
@ECHO OFF
TITLE WinXP-IE - Optional Patch Integrator
PushD "%~dp0"
".\Tools\SetConsole.exe" /h:40 /w:80 /pos:cc
CHCP 1252 1>NUL
Set "Version=3.3.0b3"
Set "BatchDir=%~dp0"
If [%BatchDir:~-1%]==[\] Set "BatchDir=%BatchDir:~0,-1%"

SETLOCAL EnableDelayedExpansion
For /f "tokens=1 delims=" %%i in ('Dir /o:-n /b /s') do (
  Set "FileAndPath=%%i"
  Set "length=!FileAndPath:~0,260!"
  If "!FileAndPath!" NEQ "!length!" Set "MPL=1"
)
SETLOCAL DisableDelayedExpansion

Set "WinXP=Windows XP Professional SP3 x86 - Integral Edition"
Set "CompileDir=%SystemDrive%\_compiling"
Set "TempDir=%CompileDir%\_temp"
Set "on=(YES)"
Set "off=(NO) "
Set "optM2SATA=%off%"
Set "optM2NVMe=%off%"
Set "optM2USB=%off%"
Set "optACPI=%off%"
Set "optPAE4=%off%"
Set "optPAE128=%off%"
Set "optAVX=%off%"
Set "optKMDF=%off%"
Set "optUAS=%off%"
Set "optASATA=%off%"
Set "optTF=%off%"
Set "optLUSB=%off%"
Set "optDPB=%off%"
Set "optSSE2=%off%"
Set "optKSATA=%off%"
Set "optUISATA=%off%"
Set "optSNVMe=%off%"
Set "optK3NVMe=%off%"
Set "optK5NVMe=%off%"
Set "optA1USB=%off%"
Set "optA2USB=%off%"

:MENU
CLS
ECHO                                      \\!//
ECHO                                      (o o)
ECHO ---------------------------------oOOo-(_)-oOOo---------------------------------
ECHO        Windows XP - Integral Edition - Optional Patch Integrator v%Version%
ECHO           INFO: Some of those Patches may not work on all computers.
ECHO ===============================================================================

If Not "%MPL%"=="1" GoTo SKIP
COLOR 0C
ECHO.
ECHO You reached the maximum path length for this script.
ECHO Please put the script folder in a shorter directory, Like for example:
ECHO "%Userprofile%\Desktop" or "%Userprofile%\Documents" or "%SystemDrive%\"
ECHO.
Pause
EXIT
:SKIP

If "%optM2USB%"=="%on%" Set "optKMDF=%on%"

ECHO.
ECHO           * Standard Options:
ECHO.
<NUL Set/P=[1] & (If "%optM2SATA%"=="%on%" (Call :EchoColor "%optM2SATA%" 0a) Else (<NUL Set/P="%optM2SATA%")) & ECHO  Add MovAX-Gen2 SATA/AHCI driver (Backported Win8 driver).
<NUL Set/P=[2] & (If "%optM2NVMe%"=="%on%" (Call :EchoColor "%optM2NVMe%" 0a) Else (<NUL Set/P="%optM2NVMe%")) & ECHO  Add MovAX-Gen2 NVMe driver (Backported Win7 driver).
<NUL Set/P=[3] & (If "%optM2USB%"=="%on%" (Call :EchoColor "%optM2USB%" 0a) Else (<NUL Set/P="%optM2USB%")) & ECHO  Add MovAX-Gen2 USB3.X xHCI driver (Backported Win8 driver).
<NUL Set/P=[4] & (If "%optACPI%"=="%on%" (Call :EchoColor "%optACPI%" 0a) Else (<NUL Set/P="%optACPI%")) & ECHO  Add ACPI Patch (For mainboards that are newer than 2016).
<NUL Set/P=[5] & (If "%optPAE4%"=="%on%" (Call :EchoColor "%optPAE4%" 0a) Else (<NUL Set/P="%optPAE4%")) & ECHO  Add PAE 4GB RAM Patch (Use this to avoid stability issues).
<NUL Set/P=[6] & (If "%optPAE128%"=="%on%" (Call :EchoColor "%optPAE128%" 0a) Else (<NUL Set/P="%optPAE128%")) & ECHO  Add PAE 128GB RAM Patch (May have stability issues).
<NUL Set/P=[7] & (If "%optAVX%"=="%on%" (Call :EchoColor "%optAVX%" 0a) Else (<NUL Set/P="%optAVX%")) & ECHO  Add AVX/AVX2 256-bit Enabler (For Multi-Core CPUs with PAE).
ECHO.
ECHO           * Additional Options:
ECHO.
<NUL Set/P=[A] & (If "%optKMDF%"=="%on%" (Call :EchoColor "%optKMDF%" 0a) Else (<NUL Set/P="%optKMDF%")) & ECHO  Add Kernel-Mode Driver Framework 1.11 (Backported Win7 driver).
<NUL Set/P=[B] & (If "%optUAS%"=="%on%" (Call :EchoColor "%optUAS%" 0a) Else (<NUL Set/P="%optUAS%")) & ECHO  Add UAS/UASP driver (Improves USB storage device performance).
<NUL Set/P=[C] & (If "%optTF%"=="%on%" (Call :EchoColor "%optTF%" 0a) Else (<NUL Set/P="%optTF%")) & ECHO  Add PM/RTC Timer Fix (For Intel CPUs that are newer than 2014).
<NUL Set/P=[D] & (If "%optLUSB%"=="%on%" (Call :EchoColor "%optLUSB%" 0a) Else (<NUL Set/P="%optLUSB%")) & ECHO  Add configuration settings to create a Live USB Setup.
<NUL Set/P=[E] & (If "%optDPB%"=="%on%" (Call :EchoColor "%optDPB%" 0a) Else (<NUL Set/P="%optDPB%")) & ECHO  Remove DriverPacks BASE with the included Driver Packs.
<NUL Set/P=[F] & (If "%optSSE2%"=="%on%" (Call :EchoColor "%optSSE2%" 0a) Else (<NUL Set/P="%optSSE2%")) & ECHO  Remove Windows XP SP3 SSE2 Updates (For CPUs without SSE2 support).
ECHO.
ECHO           * Alternative Options:
ECHO.
<NUL Set/P=[G] & (If "%optKSATA%"=="%on%" (Call :EchoColor "%optKSATA%" 0a) Else (<NUL Set/P="%optKSATA%")) & ECHO  Add Kai-Schtrom SATA driver (Backported Win8 driver).
<NUL Set/P=[H] & (If "%optUISATA%"=="%on%" (Call :EchoColor "%optUISATA%" 0a) Else (<NUL Set/P="%optUISATA%")) & ECHO  Add Universal Intel SATA driver v11.2.0.1006 (For RST Series).
<NUL Set/P=[I] & (If "%optASATA%"=="%on%" (Call :EchoColor "%optASATA%" 0a) Else (<NUL Set/P="%optASATA%")) & ECHO  Add AMD SATA/AHCI driver (Backported Win7 driver).
<NUL Set/P=[J] & (If "%optSNVMe%"=="%on%" (Call :EchoColor "%optSNVMe%" 0a) Else (<NUL Set/P="%optSNVMe%")) & ECHO  Add Samsung NVMe driver (Backported Win7 driver).
<NUL Set/P=[K] & (If "%optK3NVMe%"=="%on%" (Call :EchoColor "%optK3NVMe%" 0a) Else (<NUL Set/P="%optK3NVMe%")) & ECHO  Add Kai-Schtrom NVMe driver v1.3 (Backported Win7 OFA driver).
<NUL Set/P=[M] & (If "%optK5NVMe%"=="%on%" (Call :EchoColor "%optK5NVMe%" 0a) Else (<NUL Set/P="%optK5NVMe%")) & ECHO  Add Kai-Schtrom NVMe driver v1.5 (Backported Win7 OFA driver).
<NUL Set/P=[N] & (If "%optA1USB%"=="%on%" (Call :EchoColor "%optA1USB%" 0a) Else (<NUL Set/P="%optA1USB%")) & ECHO  Add AMD/Intel v145 USB3.0 xHCI driver (Patched Win7 AMD driver).
<NUL Set/P=[L] & (If "%optA2USB%"=="%on%" (Call :EchoColor "%optA2USB%" 0a) Else (<NUL Set/P="%optA2USB%")) & ECHO  Add AMD/Intel v276 USB3.0 xHCI driver (Patched Win7 AMD driver).

ECHO.
If Not Exist ".\Tools\Choice.exe" ECHO ERROR: File "Choice.exe" not found. & ECHO. & Pause & GoTo END
".\Tools\Choice.exe" /c 1234567ABCDEFGHIJKMNLX /n /m "--------> Toggle your option(s) and toggle [X] to Start: "

If ERRORLEVEL 22 GoTo CONTINUE
If ERRORLEVEL 21 (If "%optA2USB%"=="%on%" (Set "optA2USB=%off%") Else (Set "optA2USB=%on%" & Set "optA1USB=%off%" & Set "optM2USB=%off%" & Set "optKMDF=%off%" & Set "optUAS=%off%")) & GoTo MENU
If ERRORLEVEL 20 (If "%optA1USB%"=="%on%" (Set "optA1USB=%off%") Else (Set "optA1USB=%on%" & Set "optA2USB=%off%" & Set "optM2USB=%off%" & Set "optKMDF=%off%" & Set "optUAS=%off%")) & GoTo MENU
If ERRORLEVEL 19 (If "%optK5NVMe%"=="%on%" (Set "optK5NVMe=%off%") Else (Set "optK5NVMe=%on%" & Set "optM2NVMe=%off%" & Set "optSNVMe=%off%" & Set "optK3NVMe=%off%")) & GoTo MENU
If ERRORLEVEL 18 (If "%optK3NVMe%"=="%on%" (Set "optK3NVMe=%off%") Else (Set "optK3NVMe=%on%" & Set "optM2NVMe=%off%" & Set "optSNVMe=%off%" & Set "optK5NVMe=%off%")) & GoTo MENU
If ERRORLEVEL 17 (If "%optSNVMe%"=="%on%" (Set "optSNVMe=%off%") Else (Set "optSNVMe=%on%" & Set "optM2NVMe=%off%" & Set "optK3NVMe=%off%" & Set "optK5NVMe=%off%")) & GoTo MENU
If ERRORLEVEL 16 (If "%optASATA%"=="%on%" (Set "optASATA=%off%" & Set "optDPB=%off%") Else (Set "optASATA=%on%" & Set "optDPB=%on%" & Set "optM2SATA=%off%" & Set "optKSATA=%off%" & Set "optUISATA=%off%")) & GoTo MENU
If ERRORLEVEL 15 (If "%optUISATA%"=="%on%" (Set "optUISATA=%off%" & Set "optDPB=%off%") Else (Set "optUISATA=%on%" & Set "optDPB=%off%" & Set "optM2SATA=%off%" & Set "optKSATA=%off%" & Set "optASATA=%off%")) & GoTo MENU
If ERRORLEVEL 14 (If "%optKSATA%"=="%on%" (Set "optKSATA=%off%" & Set "optDPB=%off%") Else (Set "optKSATA=%on%" & Set "optDPB=%on%" & Set "optM2SATA=%off%" & Set "optUISATA=%off%" & Set "optASATA=%off%")) & GoTo MENU
If ERRORLEVEL 13 (If "%optSSE2%"=="%on%" (Set "optSSE2=%off%") Else (Set "optSSE2=%on%")) & GoTo MENU
If ERRORLEVEL 12 (If "%optDPB%"=="%on%" (Set "optDPB=%off%") Else (Set "optDPB=%on%")) & GoTo MENU
If ERRORLEVEL 11 (If "%optLUSB%"=="%on%" (Set "optLUSB=%off%") Else (Set "optLUSB=%on%")) & GoTo MENU
If ERRORLEVEL 10 (If "%optTF%"=="%on%" (Set "optTF=%off%") Else (Set "optTF=%on%")) & GoTo MENU
If ERRORLEVEL 9 (If "%optUAS%"=="%on%" (Set "optUAS=%off%") Else (Set "optUAS=%on%")) & GoTo MENU
If ERRORLEVEL 8 (If "%optKMDF%"=="%on%" (Set "optKMDF=%off%") Else (Set "optKMDF=%on%")) & GoTo MENU
If ERRORLEVEL 7 (If "%optAVX%"=="%on%" (Set "optAVX=%off%") Else (Set "optAVX=%on%")) & GoTo MENU
If ERRORLEVEL 6 (If "%optPAE128%"=="%on%" (Set "optPAE128=%off%") Else (Set "optPAE128=%on%" & Set "optPAE4=%off%")) & GoTo MENU
If ERRORLEVEL 5 (If "%optPAE4%"=="%on%" (Set "optPAE4=%off%") Else (Set "optPAE4=%on%" & Set "optPAE128=%off%")) & GoTo MENU
If ERRORLEVEL 4 (If "%optACPI%"=="%on%" (Set "optACPI=%off%" & Set "optTF=%off%") Else (Set "optACPI=%on%" & Set "optTF=%on%")) & GoTo MENU
If ERRORLEVEL 3 (If "%optM2USB%"=="%on%" (Set "optM2USB=%off%" & Set "optKMDF=%off%" & Set "optUAS=%off%") Else (Set "optM2USB=%on%" & Set "optUAS=%on%" & Set "optA1USB=%off%" & Set "optA2USB=%off%")) & GoTo MENU
If ERRORLEVEL 2 (If "%optM2NVMe%"=="%on%" (Set "optM2NVMe=%off%") Else (Set "optM2NVMe=%on%" & Set "optSNVMe=%off%" & Set "optK3NVMe=%off%" & Set "optK5NVMe=%off%")) & GoTo MENU
If ERRORLEVEL 1 (If "%optM2SATA%"=="%on%" (Set "optM2SATA=%off%" & Set "optDPB=%off%") Else (Set "optM2SATA=%on%" & Set "optDPB=%on%" & Set "optKSATA=%off%" & Set "optUISATA=%off%" & Set "optASATA=%off%")) & GoTo MENU

::ECHO.
::Set /P op="Toggle your option(s) AND PRESS ENTER: "
::If /I "%op%"=="1" (If "%optNAME%"=="%on%" (Set "optNAME=%off%") Else (Set "optNAME=%on%")) & GoTo MENU
::If /I "%op%"=="X" GoTo CONTINUE
::GoTo MENU

:EchoColor (Text, Color)
  MkDir "%temp%\_%1" 1>NUL
  PushD "%temp%\_%1"
  For /f %%a in ('Echo PROMPT $H ^| "CMD"') do Set "bs=%%a"
  <NUL Set /P="_" >"%1"
  FindStr /s /b /p /a:%2 /i /c:"_" "%1"
  <NUL Set /P=%bs%%bs%
  PushD "%~dp0"
  RmDir /s /q "%temp%\_%1"
GoTo :EOF

:CONTINUE
ECHO.
ECHO -------------------------------------------------------------------------------

Echo %optM2SATA% %optM2NVMe% %optM2USB% %optACPI% %optPAE4% %optPAE128% %optAVX% %optDPB% %optKMDF% %optUAS% %optTF% %optLUSB% %optSSE2% %optKSATA% %optUISATA% %optSNVMe% %optK3NVMe% %optK5NVMe% %optA1USB% %optA2USB% | FindStr /l /i "%on%" >NUL 2>&1 && GoTo SKIP
ECHO.
ECHO No option were selected. O_o ?
GoTo END
:SKIP

ECHO.
ECHO Extracting WinXP-IE "*(Vanilla).iso" file . . .
RmDir /s /q "%TempDir%" 2>NUL
RmDir /s /q "%CompileDir%" 2>NUL
ping -n 3 localhost 1>NUL
For /f "delims==" %%i in ('Dir /b "..\%WinXP%*(Vanilla).iso" 2^>nul') do Set "VDir=..\%%i"
For /f "delims==" %%i in ('Dir /b ".\%WinXP%*(Vanilla).iso" 2^>nul') do Set "VDir=.\%%i"
".\Tools\7z.exe" x "%VDir%" -y -o"%CompileDir%\" -bso0
If "%ERRORLEVEL%" NEQ "0" ECHO. & ECHO INFO: Make sure that the ISO file is in the same folder or parent folder as & ECHO       the scipt, and that the ISO file is also named "*(Vanilla).iso". & ECHO. & Pause & GoTo END
MkDir "%TempDir%\"
Echo %optACPI% %optAVX% %optPAE4% %optPAE128% %optTF% | FindStr /l /i "%on%" >NUL 2>&1 || GoTo SKIP
ECHO.
If Exist "%CompileDir%\I386\SP3.CAB" (Set "WCF=SP3") Else (Set "WCF=DRIVER")
RmDir /s /q "%TempDir%\%WCF%-cab" 2>NUL
ECHO Extracting %WCF%.cab file . . .
ping -n 3 localhost 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\%WCF%.CAB" -y -o"%TempDir%\%WCF%-cab\" -bso0
:SKIP


If "%optDPB%"=="%off%" GoTo SKIP
ECHO.
ECHO -------------------------[ DriverPacks BASE Remover ]--------------------------
ECHO.
If Not Exist "%CompileDir%\I386\SETUP.ORG" ECHO SKIPED: No DriverPacks BASE was found. & GoTo SKIP
If Exist "%CompileDir%\I386\ADPU160M.ORG" GoTo DPM
ECHO Creating a backup file of "I386\WINNT.SIF" to "OEM\WINNT.SIF.backup" . . .
ping -n 3 localhost 1>NUL
ECHO F| XCOPY "%CompileDir%\I386\WINNT.SIF" "%CompileDir%\OEM\WINNT.SIF.backup" /V /Y /Z 1>NUL
ECHO.
ECHO Replacing all the modified system files with the original system files . . .
ping -n 3 localhost 1>NUL
MOVE /y "%CompileDir%\I386\DOSNET.ORG" "%CompileDir%\I386\DOSNET.INF" 1>NUL
MOVE /y "%CompileDir%\I386\SETUP.ORG" "%CompileDir%\I386\SETUP.EX_" 1>NUL
MOVE /y "%CompileDir%\I386\TXTSETUP.ORG" "%CompileDir%\I386\TXTSETUP.SIF" 1>NUL
MOVE /y "%CompileDir%\I386\WINNT.ORG" "%CompileDir%\I386\WINNT.SIF" 1>NUL
ECHO.
ECHO Deleting all the DriverPacks BASE files . . .
ping -n 3 localhost 1>NUL
RmDir /s /q "%CompileDir%\OEM\bin"
DEL /f "%CompileDir%\OEM\DP*.7z"
DEL /f "%CompileDir%\OEM\DP_Install_Tool.cmd"
DEL /f "%CompileDir%\OEM\DPINST.exe"
DEL /f "%CompileDir%\OEM\DPInst.xml"
DEL /f "%CompileDir%\I386\PRESETUP.CMD"
DEL /f "%CompileDir%\I386\SETUPORG.EXE"
GoTo SKIP
:DPM
ECHO Creating a backup file of "I386\WINNT.SIF" to "OEM\WINNT.SIF.backup" . . .
ping -n 3 localhost 1>NUL
ECHO F| XCOPY "%CompileDir%\I386\WINNT.SIF" "%CompileDir%\OEM\WINNT.SIF.backup" /V /Y /Z 1>NUL
ECHO.
ECHO Replacing all the modified system files with the original system files . . .
ping -n 3 localhost 1>NUL
MOVE /y "%CompileDir%\I386\ADPU160M.ORG" "%CompileDir%\I386\ADPU160M.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\DAC2W2K.ORG" "%CompileDir%\I386\DAC2W2K.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\DAC960NT.ORG" "%CompileDir%\I386\DAC960NT.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\DOSNET.ORG" "%CompileDir%\I386\DOSNET.INF" 1>NUL
MOVE /y "%CompileDir%\I386\DPTI2O.ORG" "%CompileDir%\I386\DPTI2O.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\MRAID35X.ORG" "%CompileDir%\I386\MRAID35X.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\PERC2.ORG" "%CompileDir%\I386\PERC2.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\QL12160.ORG" "%CompileDir%\I386\QL12160.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\SETUP.ORG" "%CompileDir%\I386\SETUP.EX_" 1>NUL
MOVE /y "%CompileDir%\I386\SYM_HI.ORG" "%CompileDir%\I386\SYM_HI.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\SYMC8XX.ORG" "%CompileDir%\I386\SYMC8XX.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\SYMC810.ORG" "%CompileDir%\I386\SYMC810.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\TXTSETUP.ORG" "%CompileDir%\I386\TXTSETUP.SIF" 1>NUL
MOVE /y "%CompileDir%\I386\ULTRA.ORG" "%CompileDir%\I386\ULTRA.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\VIAIDE.ORG" "%CompileDir%\I386\VIAIDE.SY_" 1>NUL
MOVE /y "%CompileDir%\I386\WINNT.ORG" "%CompileDir%\I386\WINNT.SIF" 1>NUL
ECHO.
ECHO Deleting all the DriverPacks BASE files . . .
ping -n 3 localhost 1>NUL
RmDir /s /q "%CompileDir%\OEM\bin"
DEL /f "%CompileDir%\OEM\DP*.7z"
DEL /f "%CompileDir%\OEM\DP_Install_Tool.cmd"
DEL /f "%CompileDir%\OEM\DPINST.exe"
DEL /f "%CompileDir%\OEM\DPInst.xml"
DEL /f "%CompileDir%\I386\2310_00.SY_"
DEL /f "%CompileDir%\I386\272X_1X.SY_"
DEL /f "%CompileDir%\I386\274X_3X.SY_"
DEL /f "%CompileDir%\I386\3WAREDRV.SY_"
DEL /f "%CompileDir%\I386\3WAREGSM.SY_"
DEL /f "%CompileDir%\I386\3WDRV100.SY_"
DEL /f "%CompileDir%\I386\A320RAID.SY_"
DEL /f "%CompileDir%\I386\AAC.SY_"
DEL /f "%CompileDir%\I386\AACSAS.SY_"
DEL /f "%CompileDir%\I386\AAR1210.SY_"
DEL /f "%CompileDir%\I386\AAR81XX.SY_"
DEL /f "%CompileDir%\I386\ADP3132.SY_"
DEL /f "%CompileDir%\I386\ADP94XX.SY_"
DEL /f "%CompileDir%\I386\ADPU320.SY_"
DEL /f "%CompileDir%\I386\AEC6210.SY_"
DEL /f "%CompileDir%\I386\AEC6260.SY_"
DEL /f "%CompileDir%\I386\AEC6280.SY_"
DEL /f "%CompileDir%\I386\AEC6293.SY_"
DEL /f "%CompileDir%\I386\AEC67160.SY_"
DEL /f "%CompileDir%\I386\AEC67162.SY_"
DEL /f "%CompileDir%\I386\AEC671X.SY_"
DEL /f "%CompileDir%\I386\AEC6880.SY_"
DEL /f "%CompileDir%\I386\AEC6897.SY_"
DEL /f "%CompileDir%\I386\AEC68X5.SY_"
DEL /f "%CompileDir%\I386\AHCI886X.SY_"
DEL /f "%CompileDir%\I386\AHCIT3.SY_"
DEL /f "%CompileDir%\I386\AHCIT3R.SY_"
DEL /f "%CompileDir%\I386\AHCIX70R.SY_"
DEL /f "%CompileDir%\I386\AHCIX7XX.SY_"
DEL /f "%CompileDir%\I386\AMDBUSDR.SY_"
DEL /f "%CompileDir%\I386\AMDEIDE.SY_"
DEL /f "%CompileDir%\I386\AMDHUB30.SY_"
DEL /f "%CompileDir%\I386\AMDIDE.SY_"
DEL /f "%CompileDir%\I386\AMDXHC.SY_"
DEL /f "%CompileDir%\I386\ARCM_X86.SY_"
DEL /f "%CompileDir%\I386\ASAHCI32.SY_"
DEL /f "%CompileDir%\I386\ASMTHUB3.SY_"
DEL /f "%CompileDir%\I386\ASMTXHCI.SY_"
DEL /f "%CompileDir%\I386\ATIIDE.SY_"
DEL /f "%CompileDir%\I386\CDA1000.SY_"
DEL /f "%CompileDir%\I386\CERCSR6.SY_"
DEL /f "%CompileDir%\I386\CPQARRY2.SY_"
DEL /f "%CompileDir%\I386\CPQCISSM.SY_"
DEL /f "%CompileDir%\I386\DC7280.SY_"
DEL /f "%CompileDir%\I386\DriverPack_MassStorage_wnt5_x86-32.ini" 2>NUL
DEL /f "%CompileDir%\I386\ETRONH.SY_"
DEL /f "%CompileDir%\I386\ETRONS.SY_"
DEL /f "%CompileDir%\I386\ETRONX.SY_"
DEL /f "%CompileDir%\I386\FAST2XXP.SY_"
DEL /f "%CompileDir%\I386\FASTSX.SY_"
DEL /f "%CompileDir%\I386\FASTTRAK.SY_"
DEL /f "%CompileDir%\I386\FST376XP.SY_"
DEL /f "%CompileDir%\I386\FTTXR52P.SY_"
DEL /f "%CompileDir%\I386\FTTXR54P.SY_"
DEL /f "%CompileDir%\I386\FTTXR5_O.SY_"
DEL /f "%CompileDir%\I386\HPCISSM2.SY_"
DEL /f "%CompileDir%\I386\HPT371.SY_"
DEL /f "%CompileDir%\I386\HPT374.SY_"
DEL /f "%CompileDir%\I386\HPT3XXX.SY_"
DEL /f "%CompileDir%\I386\HPTIOP.SY_"
DEL /f "%CompileDir%\I386\HPTMV.SY_"
DEL /f "%CompileDir%\I386\HPTMV6.SY_"
DEL /f "%CompileDir%\I386\HPTMVIOP.SY_"
DEL /f "%CompileDir%\I386\IASTOR0.SY_"
DEL /f "%CompileDir%\I386\IASTOR2.SY_"
DEL /f "%CompileDir%\I386\IASTOR3.SY_"
DEL /f "%CompileDir%\I386\IASTOR4.SY_"
DEL /f "%CompileDir%\I386\IASTOR5.SY_"
DEL /f "%CompileDir%\I386\IASTOR6.SY_"
DEL /f "%CompileDir%\I386\IASTOR7.SY_"
DEL /f "%CompileDir%\I386\IASTOR9.SY_"
DEL /f "%CompileDir%\I386\IDE376XP.SY_"
DEL /f "%CompileDir%\I386\INIC162X.SY_"
DEL /f "%CompileDir%\I386\IPSRAIDN.SY_"
DEL /f "%CompileDir%\I386\ITEATAPI.SY_"
DEL /f "%CompileDir%\I386\ITERAID.SY_"
DEL /f "%CompileDir%\I386\JRAID.SY_"
DEL /f "%CompileDir%\I386\M5228.SY_"
DEL /f "%CompileDir%\I386\M5281.SY_"
DEL /f "%CompileDir%\I386\M5287.SY_"
DEL /f "%CompileDir%\I386\M5288.SY_"
DEL /f "%CompileDir%\I386\M5289.SY_"
DEL /f "%CompileDir%\I386\MEGAATA.SY_"
DEL /f "%CompileDir%\I386\MEGAIDE.SY_"
DEL /f "%CompileDir%\I386\MEGASAS.SY_"
DEL /f "%CompileDir%\I386\MEGASR1.SY_"
DEL /f "%CompileDir%\I386\MEGASR2.SY_"
DEL /f "%CompileDir%\I386\MSVMSCSI.SY_"
DEL /f "%CompileDir%\I386\MV614X.SY_"
DEL /f "%CompileDir%\I386\MV61XX.SY_"
DEL /f "%CompileDir%\I386\MV61XXMM.SY_"
DEL /f "%CompileDir%\I386\MV64XX.SY_"
DEL /f "%CompileDir%\I386\MV64XXMM.SY_"
DEL /f "%CompileDir%\I386\MV91XX.SY_"
DEL /f "%CompileDir%\I386\MV94XX.SY_"
DEL /f "%CompileDir%\I386\MVSATA.SY_"
DEL /f "%CompileDir%\I386\MVXXMM.SY_"
DEL /f "%CompileDir%\I386\NFRD960X.SY_"
DEL /f "%CompileDir%\I386\NUSB3HUB.SY_"
DEL /f "%CompileDir%\I386\NUSB3XHC.SY_"
DEL /f "%CompileDir%\I386\NVATA.SY_"
DEL /f "%CompileDir%\I386\NVATABUS.SY_"
DEL /f "%CompileDir%\I386\NVATARD.SY_"
DEL /f "%CompileDir%\I386\NVGTS6.SY_"
DEL /f "%CompileDir%\I386\NVGTS6R.SY_"
DEL /f "%CompileDir%\I386\NVGTS7.SY_"
DEL /f "%CompileDir%\I386\NVGTS7R.SY_"
DEL /f "%CompileDir%\I386\NVLEGACY.SY_"
DEL /f "%CompileDir%\I386\NVRAID.SY_"
DEL /f "%CompileDir%\I386\NVRD327R.SY_"
DEL /f "%CompileDir%\I386\PNP649R.SY_"
DEL /f "%CompileDir%\I386\PNP680.SY_"
DEL /f "%CompileDir%\I386\PNP680R.SY_"
DEL /f "%CompileDir%\I386\PRESETUP.CMD"
DEL /f "%CompileDir%\I386\PRFSX4XP.SY_"
DEL /f "%CompileDir%\I386\QL2100.SY_"
DEL /f "%CompileDir%\I386\QL2200.SY_"
DEL /f "%CompileDir%\I386\R750.SY_"
DEL /f "%CompileDir%\I386\RAIDSRC.SY_"
DEL /f "%CompileDir%\I386\RC32XX.SY_"
DEL /f "%CompileDir%\I386\RCRAID1.SY_"
DEL /f "%CompileDir%\I386\RCRAID2.SY_"
DEL /f "%CompileDir%\I386\RR172X.SY_"
DEL /f "%CompileDir%\I386\RR174X.SY_"
DEL /f "%CompileDir%\I386\RR2210.SY_"
DEL /f "%CompileDir%\I386\RR232X.SY_"
DEL /f "%CompileDir%\I386\RR2340.SY_"
DEL /f "%CompileDir%\I386\RR2522.SY_"
DEL /f "%CompileDir%\I386\RR2644.SY_"
DEL /f "%CompileDir%\I386\RR2680.SY_"
DEL /f "%CompileDir%\I386\RR26XX.SY_"
DEL /f "%CompileDir%\I386\RR276X.SY_"
DEL /f "%CompileDir%\I386\RR278X.SY_"
DEL /f "%CompileDir%\I386\RR62X.SY_"
DEL /f "%CompileDir%\I386\RR640L.SY_"
DEL /f "%CompileDir%\I386\RR64X.SY_"
DEL /f "%CompileDir%\I386\RUSB3HUB.SY_"
DEL /f "%CompileDir%\I386\RUSB3XHC.SY_"
DEL /f "%CompileDir%\I386\S150SX8.SY_"
DEL /f "%CompileDir%\I386\SAS2XP86.SY_"
DEL /f "%CompileDir%\I386\SETUPORG.EXE"
DEL /f "%CompileDir%\I386\SI3112.SY_"
DEL /f "%CompileDir%\I386\SI3112R.SY_"
DEL /f "%CompileDir%\I386\SI3114.SY_"
DEL /f "%CompileDir%\I386\SI3114R.SY_"
DEL /f "%CompileDir%\I386\SI3114R5.SY_"
DEL /f "%CompileDir%\I386\SI3124.SY_"
DEL /f "%CompileDir%\I386\SI3124R.SY_"
DEL /f "%CompileDir%\I386\SI3124R5.SY_"
DEL /f "%CompileDir%\I386\SI3132B.SY_"
DEL /f "%CompileDir%\I386\SI3132B2.SY_"
DEL /f "%CompileDir%\I386\SI3132B3.SY_"
DEL /f "%CompileDir%\I386\SI3132B4.SY_"
DEL /f "%CompileDir%\I386\SI3132B5.SY_"
DEL /f "%CompileDir%\I386\SI3132B6.SY_"
DEL /f "%CompileDir%\I386\SI3132R5.SY_"
DEL /f "%CompileDir%\I386\SI3531.SY_"
DEL /f "%CompileDir%\I386\SISIDE.SY_"
DEL /f "%CompileDir%\I386\SISRAID.SY_"
DEL /f "%CompileDir%\I386\SISRAID2.SY_"
DEL /f "%CompileDir%\I386\SISRAID4.SY_"
DEL /f "%CompileDir%\I386\SPTRAK.SY_"
DEL /f "%CompileDir%\I386\SYMMPI.SY_"
DEL /f "%CompileDir%\I386\SYMMPIV.SY_"
DEL /f "%CompileDir%\I386\TIHUB3.SY_"
DEL /f "%CompileDir%\I386\TIXHCI.SY_"
DEL /f "%CompileDir%\I386\ULSATA.SY_"
DEL /f "%CompileDir%\I386\ULSATA2.SY_"
DEL /f "%CompileDir%\I386\VIAMRAID.SY_"
DEL /f "%CompileDir%\I386\VIAPDSK.SY_"
DEL /f "%CompileDir%\I386\VIOSTOR.SY_"
DEL /f "%CompileDir%\I386\VMSCSI.SY_"
DEL /f "%CompileDir%\I386\VSTXRAID.SY_"
DEL /f "%CompileDir%\I386\VSTXWDC.SY_"
:SKIP

Echo %optM2SATA% %optKSATA% %optASATA% %optM2NVMe% %optSNVMe% %optK3NVMe% %optK5NVMe% %optM2USB% %optKMDF% | FindStr /l /i "%on%" >NUL 2>&1 || GoTo SKIP
ECHO.
ECHO ---------------------------[ NTOSKRNL Emu_Extender ]---------------------------
ECHO.
ECHO INFO: Required for the drivers: Win8-SATA, NVMe, Win8-USB3.X, KMDF-1.11.
ECHO.
ECHO Copying file into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY ".\Patches\Miscellaneous\ntoskrn8.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,ntoskrn8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,ntoskrn8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "ntoskrn8.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "ntoskrn8.sys =16" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\ntoskrn8.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

Echo %optM2SATA% | FindStr /l /i "%on%" >NUL 2>&1 || GoTo SKIP
ECHO.
ECHO ----------------------[ STORPORT Windows 7 Emu_Extender ]----------------------
ECHO.
ECHO INFO: Required for the drivers: MovAX-Gen2 SATA.
ECHO.
ECHO Copying file into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY ".\Patches\Miscellaneous\storpor8.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,storpor8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,storpor8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "storpor8.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "storpor8.sys =16" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\storpor8.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

Echo %optM2SATA% %optKSATA% %optASATA% %optASATA% %optM2NVMe% %optSNVMe% %optK3NVMe% %optK5NVMe% %optM2USB% | FindStr /l /i "%on%" >NUL 2>&1 || GoTo SKIP
ECHO.
ECHO ------------------------------[ StorPort Driver ]------------------------------
ECHO.
ECHO INFO: Required for the drivers: Win8-SATA, NVMe.
ECHO.
ECHO Copying file into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY ".\Patches\Miscellaneous\storport.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,storport.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,storport.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "storport.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "storport.sys =16" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\storport.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optKMDF%"=="%off%" GoTo SKIP
ECHO.
ECHO ---------------------[ Kernel-Mode Driver Framework 1.11 ]---------------------
ECHO.
ECHO Copying file into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY ".\Patches\Kernel-Mode Driver Framework 1.11\wdf01011.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\Patches\Kernel-Mode Driver Framework 1.11\wdf01000.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,wdf01011.inf" -once
FindStr /i /e "wdf01000.sys" "%TempDir%\DOSNET.INF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,wdf01000.sys" -once
FindStr /i /e "wdfldr.sys" "%TempDir%\DOSNET.INF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,wdfldr.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "wdf01011.inf = 1,,,,,,,20,0,0" -once
FindStr /i /r "wdf01000.sys.*,." "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "wdf01000.sys = 100,,,,,,3_,4,0,0,,1,4" -once
FindStr /i /r "wdfldr.sys.*,." "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "wdfldr.sys = 100,,,,,,3_,4,0,0,,1,4" -once
FindStr /i /r "wdf01000.sys.*=*16$" "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "wdf01000.sys =16" -once
FindStr /i /r "wdfldr.sys.*=*16$" "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "wdfldr.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnceEx\Setup\",\"X1-WDF01011_INSTALL\",0x00000000,\"RunDll32.exe SetupAPI.dll,InstallHinfSection PostSetup 132 wdf01011.inf\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\wdf01011.inf" -s "SourceDisksNames" -l "1 = \"Kernel-Mode Driver Framework 1.11\",,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\wdf01011.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\wdf01000.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" ".\Patches\Kernel-Mode Driver Framework 1.11\wdfldr.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optM2SATA%"=="%off%" GoTo SKIP
ECHO.
ECHO ------------------------[ MovAX-Gen2 SATA/AHCI Driver ]------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\MovAX-Gen2 SATA driver*"
XCOPY ".\storahci.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\storahci.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,storahci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,storahci.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,storahci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "storahci.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "storahci.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_010601 = \"storahci\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "storahci = storahci.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "storahci.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "storahci = \"Standard SATA/AHCI Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\storahci\Parameters\",\"BusType\",0x00010001,\"b\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\storahci\Parameters\",\"IoTimeoutValue\",0x00010001,\"0x0000001e\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\storahci\Parameters\PnpInterface\",\"5\",0x00010003,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\storahci.inf" -s "SourceDisksNames" -l "1=%%MS-AHCI%%,,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\storahci.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\storahci.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optKSATA%"=="%off%" GoTo SKIP
ECHO.
ECHO -----------------------[ Kai-Schtrom SATA/AHCI Driver ]------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\Kai-Schtrom SATA driver*"
XCOPY ".\x86\storahci.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\storahci.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,storahci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,storahci.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,storahci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "storahci.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "storahci.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_010601 = \"storahci\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "storahci = storahci.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "storahci.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "storahci = \"StorAhci SATA AHCI Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\storahci\Parameters\",\"BusType\",0x00010001,\"b\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\storahci\Parameters\PnpInterface\",\"5\",0x00010003,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\storahci.inf" -s "SourceDisksNames" -l "1 = %%DISKNAME%%,,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\storahci.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\storahci.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optUISATA%"=="%off%" GoTo SKIP
ECHO.
ECHO -------------------[ Universal Intel SATA/AHCI/RAID Driver ]-------------------
ECHO.
ECHO INFO: The Universal Intel RST Software can be found in the Patches folder.
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\Universal Intel RST Drivers+Software*"
XCOPY ".\Drivers\x32\iaAHCI.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\Drivers\x32\iaStor.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\Drivers\x32\iaStor.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
If Not Exist "%CompileDir%\I386\ADPU160M.ORG" GoTo NEXT
ECHO.
ECHO Removing DriverPacks BASE entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,iastor9.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,iastor7.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,iaStor6.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,iaStor5.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,iastor4.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,iastor3.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,iaStor2.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iastor9.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iastor7.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iaStor6.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iaStor5.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iastor4.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iastor3.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iaStor2.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "iaStor2.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "iastor3.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "iastor4.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "iaStor5.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "iaStor6.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "iastor7.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "iastor9.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2652&CC_0104=\"iaStor2\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2652&CC_0106=\"iaStor2\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_24D1&CC_0106=\"iastor3\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2653&CC_0106=\"iastor3\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2681&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2682&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_5029&CC_0106=\"iastor4\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C5&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2651&CC_0106=\"iastor4\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2821&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2829&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2826&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1D02&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2824&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2922&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A02&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C1&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2923&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2929&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A03&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A22&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A23&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3B29&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3B2F&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3B22&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1C02&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1C03&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8D02&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8D62&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1F22&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1F32&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_0F23&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_5AE3&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1E02&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1E03&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C02&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C03&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C02&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C03&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C82&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C83&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C82&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C83&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9D03&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A102&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A103&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A282&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9DD3&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A352&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A353&CC_0106=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C3&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C6&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2822&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_282A&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2827&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9D07&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A106&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A107&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A286&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A28E&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9DD7&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A356&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A357&CC_0104=\"iastor9\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iaStor2=iaStor2.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iastor3=iastor3.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iastor4=iastor4.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iaStor5=iaStor5.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iaStor6=iaStor6.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iastor7=iastor7.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iastor9=iastor9.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor2=\"Intel 82801FR(ICH6R) Matrix 6.0 SATA-AHCI/RAID\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iastor3=\"Intel 82801FB/FW/FBM(ICH6RW/M) Matrix 7.0 SATA-AHCI\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iastor4=\"Intel xESB/ICH7-R(M)DH/EP80579 - Matrix 7.8\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor5=\"Intel ICH8M-E/R/DO/DH SATA-AHCI - RST 10.1\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor6=\"Intel C600/X79 Series SATA-AHCI/RAID - RST 10.5 (WXP)\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iastor7=\"Intel ICH8/9R/DO/DH/ICH10D/DO SATA-AHCI - RST 10.8\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iastor9=\"Intel ICH7M/R-DH/8R/9M/10,5/6/7/8/9/100/200/300/X299 Series - RST 11.2 Mod By Dibya\"" -once
:NEXT
If Not Exist "%CompileDir%\OEM\DPM*.7z" GoTo NEXT
ECHO.
ECHO Editing DriverPacks BASE source files, Please wait . . .
ping -n 3 localhost 1>NUL
For /f "tokens=*" %%a in ('Dir /b /a:-d "%CompileDir%\OEM\DPM*.7z"') do Set "DPM_File=%%a"
".\Tools\7z.exe" e "%CompileDir%\OEM\%DPM_File%" -y "DriverPack_MassStorage_wnt5_x86-32.ini" -o"%CompileDir%\OEM\" -bso0 -bsp0
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "I-2" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "I-3" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "I-4" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "I-5" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "I-6" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "I-7" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "I-9" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-2]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-3]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-4]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-5]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-6]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-7]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-8]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[I-9]" -once
".\Tools\7z.exe" u "%CompileDir%\OEM\%DPM_File%" "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -bso0 -bsp0
DEL /f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini"
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\2" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\3" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\4" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\5" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\6" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\7" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\8" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\I\9" -bso0 -bsp0
::For /f "tokens=*" %%a in ('Dir /b /a:-d "%CompileDir%\OEM\RunOnce\Programs\Driver Packs\Driver Packs v*.7z"') do Set "DP_File=%%a"
::".\Tools\7z.exe" d "%CompileDir%\OEM\RunOnce\Programs\Driver Packs\%DP_File%" "WdfCoInstaller01007.dll" "WdfCoInstaller01009.dll" -r -bso0 -bsp0
:NEXT
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,iaStor.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iaAHCI.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iaStor.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,iaStor.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "iaAHCI.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "iaStor.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "iaStor.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2681&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C1&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C5&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2821&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2824&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2829&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2922&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2923&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2929&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A02&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A22&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A03&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3A23&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3B29&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3B2F&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_3B22&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1C02&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1C03&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1D02&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8D02&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8D62&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1F22&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1F32&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_0816&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_0F23&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_22A3&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_5AE3&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_31E3&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1E02&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_1E03&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C02&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C03&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C02&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C03&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C82&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_8C83&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C82&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9C83&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9D03&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A102&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A103&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A282&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9DD3&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A352&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A353&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_34D3&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_02D3&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_06D2&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_06D3&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A382&CC_0106 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2682&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C3&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_27C6&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2822&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_282A&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2826&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_2827&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9D07&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A106&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A107&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A286&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A28E&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_9DD7&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A356&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A357&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A35E&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_34D7&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_02D7&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_06D6&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_06D7&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_06DE&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&DEV_A386&CC_0104 = \"iaStor\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "iaStor = iaStor.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "iaStor.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A386 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A35E added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A357 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A356 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A28E added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A286 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A107 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_A106 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_9DD7 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_9D07 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_34D7 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_282A\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_2827 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_2826 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_2822\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_27C6\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_27C3\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_2682 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_06DE added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_06D7 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_06D6 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA RAID Controller DEV_02D7 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_A382 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_A353 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_A352 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_A282 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_A103 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_A102 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_9DD3 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_9D03 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_9C83 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_9C82 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_9C03 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_9C02 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_8D62 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_8D02 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_8C83 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_8C82 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_8C03 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_8C02 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_5AE3 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_3B2F\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_3B29\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_3B22\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_3A23 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_3A22\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_3A03 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_3A02\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_34D3 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_31E3 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_2929\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_2923 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_2922 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_2829 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_2824 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_2821 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_27C5\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_27C1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_2681 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_22A3 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_1F32 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_1F22 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_1E03\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_1E02\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_1D02 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_1C03\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_1C02\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_0F23 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_0816 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_06D3 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_06D2 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "iaStor = \"Intel(R) SATA AHCI Controller DEV_02D3 added by Fernando\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\iaStor\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\iaStor\",\"Group\",0x00000000,\"SCSI Miniport\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\iaStor\",\"Start\",0x00010003,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\iaStor\",\"Tag\",0x00010001,\"1b\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\iaStor\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\iaAHCI.inf" -s "SourceDisksNames" -l "1 = %%DiskName%%,,,\"\I386\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\iaStor.inf" -s "SourceDisksNames" -l "1 = %%DiskName%%,,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\iaAHCI.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\iaStor.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\iaStor.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optASATA%"=="%off%" GoTo SKIP
ECHO.
ECHO ---------------------------[ AMD SATA/AHCI Driver ]----------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\AMD SATA driver*"
XCOPY ".\amd_sata.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\amd_sata.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\amd_xata.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,amd_sata.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,amd_xata.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amd_sata.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amd_sata.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amd_xata.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amd_sata.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amd_sata.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amd_xata.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_010601 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_43B7&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_43C8&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7904&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7901&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7804&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7801&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1002&DEV_4394&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1002&DEV_4391&CC_0106 = \"amd_sata\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amd_sata = amd_sata.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amd_sata = amd_xata.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amd_sata.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amd_xata.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amd_sata = \"AMD SATA/AHCI Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\amd_sata\Device\",\"AmdSataShutdown\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\amd_sata\Device\",\"oem\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\amd_sata\Parameters\PnpInterface\",\"5\",0x00010003,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\amd_sata.inf" -s "SourceDisksNames" -l "1 = %%DiskId%%,,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\amd_sata.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amd_sata.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amd_xata.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optM2NVMe%"=="%off%" GoTo SKIP
ECHO.
ECHO --------------------------[ MovAX-Gen2 NVMe Driver ]---------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\MovAX-Gen2 NVMe driver*"
XCOPY ".\stornvme.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\stornvme.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,stornvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,stornvme.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,stornvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "stornvme.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "stornvme.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_010802 = \"stornvme\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "stornvme = stornvme.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "stornvme.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "stornvme = \"Standard NVM Express Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\stornvme\Parameters\",\"BusType\",0x00010001,\"0x00000011\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\stornvme\Parameters\",\"IoTimeoutValue\",0x00010001,\"a\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\stornvme\Parameters\PnpInterface\",\"5\",0x00010003,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\stornvme.inf" -s "SourceDisksNames" -l "1 = %%DiskName%%,,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\stornvme.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\stornvme.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optSNVMe%"=="%off%" GoTo SKIP
ECHO.
ECHO ----------------------------[ Samsung NVMe Driver ]----------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\Samsung NVMe driver*"
XCOPY ".\secnvme.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\secnvme.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\secnvmeF.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,secnvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,secnvmeF.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,secnvme.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,secnvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,secnvmeF.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "secnvme.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "secnvme.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "secnvmeF.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_144D&CC_0108 = \"secnvme\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_0108 = \"secnvme\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "secnvme = secnvme.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "secnvme = secnvmeF.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "secnvme.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "secnvmeF.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "secnvme = \"Samsung NVMe Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\secnvme\",\"Tag\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\secnvme.inf" -s "SourceDisksNames" -l "1 = \"%%DiskId1%%\",,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\secnvme.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\secnvme.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\secnvmeF.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optK3NVMe%"=="%off%" GoTo SKIP
ECHO.
ECHO -----------------------[ Kai-Schtrom NVMe Driver v1.3 ]------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\Kai-Schtrom NVMe drivers\OFA NVMe driver v1.3*"
XCOPY ".\x86\nvme.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\nvme.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,nvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,nvme.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,nvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "nvme.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "nvme.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_010802 = \"nvme\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "nvme = nvme.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "nvme.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "nvme = \"Kai OFA NVMe 1.3 Storport Miniport\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\",\"BusType\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"Namespaces\",0x00010001,\"0x00000010\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"MaxTXSize\",0x00010001,\"0x00020000\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"AdQEntries\",0x00010001,\"0x00000080\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"IoQEntries\",0x00010001,\"0x00000400\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"IntCoalescingTime\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"IntCoalescingEntries\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\PnpInterface\",\"5\",0x00010003,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\nvme.inf" -s "SourceDisksNames" -l "1 = %%DiskId1%%,,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\nvme.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\nvme.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optK5NVMe%"=="%off%" GoTo SKIP
ECHO.
ECHO -----------------------[ Kai-Schtrom NVMe Driver v1.5 ]------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\Kai-Schtrom NVMe drivers\OFA NVMe driver v1.5*"
XCOPY ".\x86\nvme.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\nvme.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.1" -l "d1,nvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,nvme.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,nvme.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "nvme.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "nvme.sys = 1,,,,,,3_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_010802 = \"nvme\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "nvme = nvme.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "nvme.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "nvme = \"Kai OFA NVMe 1.5 Storport Miniport\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\",\"BusType\",0x00010001,\"0x00000011\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"Namespaces\",0x00010001,\"0x00000010\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"MaxTXSize\",0x00010001,\"0x00020000\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"AdQEntries\",0x00010001,\"0x00000080\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"IoQEntries\",0x00010001,\"0x00000400\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"IntCoalescingTime\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\Device\",\"IntCoalescingEntries\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\nvme\Parameters\PnpInterface\",\"5\",0x00010003,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\nvme.inf" -s "SourceDisksNames" -l "1 = %%DiskId1%%,,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\nvme.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\nvme.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optM2USB%"=="%off%" GoTo SKIP
ECHO.
ECHO -----------------------[ MovAX-Gen2 USB3.X xHCI Driver ]-----------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\MovAX-Gen2 USB3.X xHCI driver*"
XCOPY ".\ksecd8.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\ucx01000.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\usbd8.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\usbhub3.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\usbhub3.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\usbxhci.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\usbxhci.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\wpprecor.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\SETUPREG.HIV" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
If Not Exist "%CompileDir%\I386\ADPU160M.ORG" GoTo NEXT
ECHO.
ECHO Removing DriverPacks BASE entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,tihub3.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,tixhci.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,asmthub3.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,asmtxhci.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,rusb3hub.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,rusb3xhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,nusb3hub.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,nusb3xhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,etrons.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,etronh.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,etronx.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,tihub3.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,tixhci.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,asmthub3.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,asmtxhci.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,rusb3hub.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,rusb3xhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,nusb3hub.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,nusb3xhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,etrons.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,etronh.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,etronx.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "etronx.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "etronh.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "etrons.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "nusb3xhc.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "nusb3hub.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "rusb3xhc.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "rusb3hub.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "amdxhc.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "amdhub30.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "asmtxhci.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "asmthub3.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "tixhci.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "tihub3.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7023&CC_0C0330=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7052&CC_0C0330=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7023&SUBSYS_80301025=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7023&SUBSYS_06271025=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7023&SUBSYS_06081025=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7023&SUBSYS_05891025=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7023&SUBSYS_70011B5B=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B6F&DEV_7023&SUBSYS_06611025=\"etronx\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "ENUSB3\ROOT_HUB30=\"etronh\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "ENUSB3\EXT_HUB10=\"etronh\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "ENUSB3\EXT_HUB20=\"etronh\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "ENUSB3\EXT_HUB30=\"etronh\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "ENUSB\Class_08&SubClass_06&Prot_50=\"etrons\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "ENUSB\Class_08&SubClass_06&Prot_62=\"etrons\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1033&DEV_0194&REV_03=\"nusb3xhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1033&DEV_0194&REV_04=\"nusb3xhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "NUSB3\ROOT_HUB30=\"nusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "NUSB3\CLASS_09&SUBCLASS_00&PROT_00=\"nusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "NUSB3\CLASS_09&SUBCLASS_00&PROT_01=\"nusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "NUSB3\CLASS_09&SUBCLASS_00&PROT_02=\"nusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "NUSB3\CLASS_09&SUBCLASS_00&PROT_03=\"nusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "NUSB3\CLASS_09&SUBCLASS_01=\"nusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1912&DEV_0014&REV_01=\"rusb3xhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1912&DEV_0014&REV_02=\"rusb3xhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1912&DEV_0014&REV_03=\"rusb3xhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1912&DEV_0015&REV_01=\"rusb3xhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1912&DEV_0015&REV_02=\"rusb3xhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "RENESAS_USB3\ROOT_HUB30&VID_1912&PID_0014=\"rusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "RENESAS_USB3\ROOT_HUB30&VID_1912&PID_0015=\"rusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "RENESAS_USB3\CLASS_09&SUBCLASS_00&PROT_00=\"rusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "RENESAS_USB3\CLASS_09&SUBCLASS_00&PROT_01=\"rusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "RENESAS_USB3\CLASS_09&SUBCLASS_00&PROT_02=\"rusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "RENESAS_USB3\CLASS_09&SUBCLASS_00&PROT_03=\"rusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "RENESAS_USB3\CLASS_09&SUBCLASS_01=\"rusb3hub\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7812=\"amdxhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7814=\"amdxhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\ROOT_HUB30=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_00=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_01=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_02=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_03=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_01=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1040&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1040&REV_01=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1040&REV_02=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1041&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1041&REV_01=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1041&REV_02=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1042&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1042&REV_01=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1042&REV_02=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1142&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1240&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1241&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1B21&DEV_1242&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_174C&DEV_2104&REV_00=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_174C&DEV_2104&REV_01=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_174C&DEV_2104&REV_02=\"asmtxhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "USB\ASMEDIAUSBD_Hub=\"asmthub3\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "USB\ASMEDIAUSBD_Hub&VID_040E&PID_0100=\"asmthub3\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_104C&DEV_8241=\"tixhci\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "USB\TIUSBD_Hub=\"tihub3\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "USB\TIUSBD_Hub&VID_040E&PID_0100=\"tihub3\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "etronx=etronx.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "etronh=etronh.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "etrons=etrons.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "nusb3xhc=nusb3xhc.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "nusb3hub=nusb3hub.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "rusb3xhc=rusb3xhc.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "rusb3hub=rusb3hub.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdxhc=amdxhc.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdhub30=amdhub30.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "asmtxhci=asmtxhci.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "asmthub3=asmthub3.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "tixhci=tixhci.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "tihub3=tihub3.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "etronx=\"Etron USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "etronh=\"Etron USB3 Hub Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "etrons=\"Etron USB3 STOR Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "nusb3xhc=\"NEC\Renesas USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "nusb3hub=\"NEC\Renesas USB3 Hub Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "rusb3xhc=\"Renesas USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "rusb3hub=\"Renesas USB3 Hub Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdxhc=\"AMD USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdhub30=\"AMD USB3 Hub Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "asmtxhci=\"ASMedia USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "asmthub3=\"ASMedia USB3 Hub Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "tixhci=\"TI USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "tihub3=\"TI USB3 Hub Controller\"" -once
:NEXT
If Not Exist "%CompileDir%\OEM\DPM*.7z" GoTo NEXT
ECHO.
ECHO Editing DriverPacks BASE source files, Please wait . . .
ping -n 3 localhost 1>NUL
For /f "tokens=*" %%a in ('Dir /b /a:-d "%CompileDir%\OEM\DPM*.7z"') do Set "DPM_File=%%a"
".\Tools\7z.exe" e "%CompileDir%\OEM\%DPM_File%" -y "DriverPack_MassStorage_wnt5_x86-32.ini" -o"%CompileDir%\OEM\" -bso0 -bsp0
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "U3" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "U3-x86" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "U3-i386" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[U3]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[U3-x86]" -once
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[U3-i386]" -once
".\Tools\7z.exe" u "%CompileDir%\OEM\%DPM_File%" "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -bso0 -bsp0
DEL /f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini"
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3" -bso0 -bsp0
::For /f "tokens=*" %%a in ('Dir /b /a:-d "%CompileDir%\OEM\RunOnce\Programs\Driver Packs\Driver Packs v*.7z"') do Set "DP_File=%%a"
::".\Tools\7z.exe" d "%CompileDir%\OEM\RunOnce\Programs\Driver Packs\%DP_File%" "WdfCoInstaller01007.dll" "WdfCoInstaller01009.dll" -r -bso0 -bsp0
:NEXT
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,ksecd8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,ucx01000.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,usbd8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,usbhub3.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,usbxhci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,wpprecor.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,ksecd8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,ucx01000.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,usbd8.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,usbhub3.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,usbhub3.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,usbxhci.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,usbxhci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,wpprecor.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "ksecd8.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "ucx01000.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "usbd8.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "usbhub3.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "usbhub3.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "usbxhci.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "usbxhci.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "wpprecor.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\CC_0C0330 = \"usbxhci\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "USB\ROOT_HUB30 = \"usbhub3\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "USB\USB30_HUB = \"usbhub3\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "USB\USB20_HUB = \"usbhub3\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "usbhub3  = usbhub3.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "usbxhci  = usbxhci.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "wdf01000 = wdf01000.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BusExtenders.Load" -l "ucx01000 = ucx01000.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbhub3  = usbhub3.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbxhci  = usbxhci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbxhci" -l "wdfldr.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbxhci" -l "usbxhci.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbxhci" -l "usbport.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbxhci" -l "usbd.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbxhci" -l "hidparse.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbxhci" -l "hidclass.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbxhci" -l "hid.dll,2" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbhub3" -l "wdfldr.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbhub3" -l "ksecd8.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbhub3" -l "usbd8.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.usbhub3" -l "usbhub3.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.ucx01000" -l "wdfldr.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.ucx01000" -l "wpprecor.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.ucx01000" -l "ucx01000.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.wdf01000" -l "wdfldr.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.wdf01000" -l "wdf01000.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "ksecd8.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "ucx01000.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "usbd8.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "usbhub3.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "usbxhci.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "wpprecor.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport" -l "usbxhci  = \"USB 3.X Host Controller\",files.usbxhci,usbxhci" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport" -l "usbhub3  = \"USB 3.X Hub Driver\",files.usbhub3,usbhub3" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "usbxhci  = \"USB 3.X Host Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "usbhub3  = \"USB 3.X Hub Driver\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "wdf01000 = \"Kernel-Mode Driver Framework 1.11\",files.wdf01000,wdf01000" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BusExtenders" -l "ucx01000 = \"USB 3.0 Controller Extension\",files.ucx01000,ucx01000" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Control\Wdf\Kmdf\Ucx\Versions\1\1\",\"Service\",0x00000000,\"ucx01000\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Ucx01000\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Ucx01000\",\"Group\",0x00000000,\"System Bus Extender\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Ucx01000\",\"ImagePath\",0x00020000,\"system32\drivers\ucx01000.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Ucx01000\",\"Start\",0x00010003,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Ucx01000\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBHUB3\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBHUB3\",\"Group\",0x00000000,\"Input Device Support\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBHUB3\",\"ImagePath\",0x00020000,\"system32\drivers\usbhub3.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBHUB3\",\"Start\",0x00010003,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBHUB3\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBXHCI\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBXHCI\",\"Group\",0x00000000,\"Input Device Support\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBXHCI\",\"ImagePath\",0x00020000,\"system32\drivers\usbxhci.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBXHCI\",\"Start\",0x00010003,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBXHCI\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Wdf01000\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Wdf01000\",\"Group\",0x00000000,\"Boot Bus Extender\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Wdf01000\",\"ImagePath\",0x00020000,\"system32\drivers\wdf01000.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Wdf01000\",\"Start\",0x00010003,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Wdf01000\",\"Type\",0x00010001,\"1\"" -once
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Control\Wdf\Kmdf\1" setvalue "Version" "1.11" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Control\Wdf\Kmdf\KmdfLibrary\Versions\1" setvalue "Service" "Wdf01000" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Control\Wdf\Kmdf\Ucx\Versions\1\1" setvalue "Service" "ucx01000" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Control\Wdf\Schema\KmdfService" setvalue "Type" "0" 4 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Control\Wdf\Schema\KmdfService\Object" setvalue "KeyPath" "CurrentControlSet\Services" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Control\Wdf\Schema\KmdfService\Object" setvalue "KeyRoot" "SYSTEM" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\Wdf01000\Parameters" setvalue "BuildNumber" "0" 4 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\Wdf01000\Parameters" setvalue "MajorVersion" "1" 4 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\Wdf01000\Parameters" setvalue "MinorVersion" "11" 4 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\usbhub3.inf" -s "SourceDisksNames" -l "1=\"Generic USB Hub Driver\",,,\"\I386\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbxhci.inf" -s "SourceDisksNames" -l "1=\"Generic USB xHCI Host Controller\",,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\ksecd8.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\ucx01000.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbd8.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbhub3.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbhub3.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbxhci.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbxhci.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\wpprecor.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\SETUPREG.HIV" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optA1USB%"=="%off%" GoTo SKIP
ECHO.
ECHO ---------------------[ AMD/Intel v145 USB3.0 xHCI Driver ]---------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\AMD&Intel USB3.0 xHCI drivers\AMDXHCI XP 145*"
XCOPY ".\x86\amdhub30.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\amdhub30.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\amdxhc.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\amdxhc.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\SETUPREG.HIV" "%TempDir%\" /V /Y /Z 1>NUL
If Not Exist "%CompileDir%\I386\ADPU160M.ORG" GoTo NEXT
ECHO.
ECHO Removing DriverPacks BASE entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "amdxhc.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "amdhub30.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7812=\"amdxhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7814=\"amdxhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\ROOT_HUB30=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_00=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_01=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_02=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_03=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_01=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdxhc=amdxhc.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdhub30=amdhub30.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdxhc.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdhub30.sys =16" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdxhc=\"AMD USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdhub30=\"AMD USB3 Hub Controller\"" -once
:NEXT
If Not Exist "%CompileDir%\OEM\DPM*.7z" GoTo NEXT
ECHO.
ECHO Editing DriverPacks BASE source files . . .
ping -n 3 localhost 1>NUL
For /f "tokens=*" %%a in ('Dir /b /a:-d "%CompileDir%\OEM\DPM*.7z"') do Set "DPM_File=%%a"
".\Tools\7z.exe" e "%CompileDir%\OEM\%DPM_File%" -y "DriverPack_MassStorage_wnt5_x86-32.ini" -o"%CompileDir%\OEM\" -bso0 -bsp0
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "U3-x86" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[U3-x86]" -once
".\Tools\7z.exe" u "%CompileDir%\OEM\%DPM_File%" "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -bso0 -bsp0
DEL /f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini"
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\x86" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdhub30.cat" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdhub30.inf" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdxhc.cat" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdxhc.inf" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdxhc-txtsetup.oem" -bso0 -bsp0
:NEXT
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdxhc.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdhub30.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdxhc.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdxhc.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdhub30.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdhub30.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7812 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7814 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7914 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&CC_0C0330 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_15AD&CC_0C0330 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\ROOT_HUB30 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_00 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_01 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_02 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_03 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_01 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdhub30 = amdhub30.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdxhc = amdxhc.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "amdxhc   = amdxhc.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "amdhub30 = amdhub30.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "amdxhc.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "usbport.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "usbd.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "hidparse.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "hidclass.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "hid.dll,2" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdhub30" -l "amdhub30.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdxhc.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdhub30.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport" -l "amdhub30 = \"AMD USB 3.0 Hub Driver\",files.amdhub30,amdhub30" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport" -l "amdxhc   = \"AMD USB 3.0 Host Controller\",files.amdxhc,amdxhc" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdxhc   = \"AMD USB 3.0 Host Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdhub30 = \"AMD USB 3.0 Hub Driver\"" -once
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdhub30" setvalue "group" "Input Device Support" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdhub30" setvalue "tag" "5" 4 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdxhc" setvalue "group" "Input Device Support" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdxhc" setvalue "tag" "4" 4 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\amdxhc.inf" -s "SourceDisksNames" -l "1 = \"%%DISKID%%\",,,\"\I386\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\amdhub30.inf" -s "SourceDisksNames" -l "1 = \"%%DISKID%%\",,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdhub30.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdhub30.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdxhc.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdxhc.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\SETUPREG.HIV" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optA2USB%"=="%off%" GoTo SKIP
ECHO.
ECHO ---------------------[ AMD/Intel v276 USB3.0 xHCI Driver ]---------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\AMD&Intel USB3.0 xHCI drivers\AMDXHCI XP 276*"
XCOPY ".\x86\amdhub30.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\amdhub30.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\amdxhc.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\x86\amdxhc.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\SETUPREG.HIV" "%TempDir%\" /V /Y /Z 1>NUL
If Not Exist "%CompileDir%\I386\ADPU160M.ORG" GoTo NEXT
ECHO.
ECHO Removing DriverPacks BASE entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "amdxhc.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "amdhub30.sys=1,,,,,,4_,4,1,,,1,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7812=\"amdxhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7814=\"amdxhc\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\ROOT_HUB30=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_00=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_01=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_02=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_03=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_01=\"amdhub30\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdxhc=amdxhc.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdhub30=amdhub30.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdxhc.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdhub30.sys =16" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdxhc=\"AMD USB3 Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdhub30=\"AMD USB3 Hub Controller\"" -once
:NEXT
If Not Exist "%CompileDir%\OEM\DPM*.7z" GoTo NEXT
ECHO.
ECHO Editing DriverPacks BASE source files . . .
ping -n 3 localhost 1>NUL
For /f "tokens=*" %%a in ('Dir /b /a:-d "%CompileDir%\OEM\DPM*.7z"') do Set "DPM_File=%%a"
".\Tools\7z.exe" e "%CompileDir%\OEM\%DPM_File%" -y "DriverPack_MassStorage_wnt5_x86-32.ini" -o"%CompileDir%\OEM\" -bso0 -bsp0
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -s "U3-x86" -l:o ""
".\Tools\Fedit.exe" -rem -f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -l "[U3-x86]" -once
".\Tools\7z.exe" u "%CompileDir%\OEM\%DPM_File%" "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini" -bso0 -bsp0
DEL /f "%CompileDir%\OEM\DriverPack_MassStorage_wnt5_x86-32.ini"
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\x86" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdhub30.cat" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdhub30.inf" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdxhc.cat" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdxhc.inf" -bso0 -bsp0
".\Tools\7z.exe" d "%CompileDir%\OEM\%DPM_File%" "D\M\U3\amdxhc-txtsetup.oem" -bso0 -bsp0
:NEXT
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "FloppyFiles.2" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdxhc.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdxhc.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdhub30.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,amdhub30.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdxhc.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdxhc.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdhub30.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "amdhub30.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7812 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7814 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_1022&DEV_7914 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_8086&CC_0C0330 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "PCI\VEN_15AD&CC_0C0330 = \"amdxhc\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\ROOT_HUB30 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_00 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_01 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_02 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_00&PROT_03 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "HardwareIdsDatabase" -l "AMDUSB30\CLASS_09&SUBCLASS_01 = \"amdhub30\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdhub30 = amdhub30.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "amdxhc = amdxhc.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "amdxhc   = amdxhc.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "amdhub30 = amdhub30.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "amdxhc.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "usbport.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "usbd.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "hidparse.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "hidclass.sys,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdxhc" -l "hid.dll,2" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "files.amdhub30" -l "amdhub30.sys,4" -create
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdxhc.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "amdhub30.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport" -l "amdhub30 = \"AMD USB 3.0 Hub Driver\",files.amdhub30,amdhub30" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport" -l "amdxhc   = \"AMD USB 3.0 Host Controller\",files.amdxhc,amdxhc" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdxhc   = \"AMD USB 3.0 Host Controller\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "amdhub30 = \"AMD USB 3.0 Hub Driver\"" -once
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdhub30" setvalue "group" "Input Device Support" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdhub30" setvalue "tag" "5" 4 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdxhc" setvalue "group" "Input Device Support" 1 1>NUL
".\Tools\offlinereg-win32.exe" "%TempDir%\SETUPREG.HIV" "ControlSet001\Services\amdxhc" setvalue "tag" "4" 4 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\amdxhc.inf" -s "SourceDisksNames" -l "1 = \"%%DISKID%%\",,,\"\I386\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\amdhub30.inf" -s "SourceDisksNames" -l "1 = \"%%DISKID%%\",,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdhub30.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdhub30.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdxhc.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\amdxhc.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\SETUPREG.HIV" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optUAS%"=="%off%" GoTo SKIP
ECHO.
ECHO ------------------------------[ UAS/UASP Driver ]------------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\MovAX-Gen2 USB3.X xHCI driver*"
XCOPY ".\uaspstor.inf" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\uaspstor.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\usbd8.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\wpprecor.sys" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,uaspstor.inf" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,uaspstor.sys" -once
FindStr /i /e "usbd8.sys" "%TempDir%\DOSNET.INF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,usbd8.sys" -once
FindStr /i /e "wpprecor.sys" "%TempDir%\DOSNET.INF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,wpprecor.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "uaspstor.inf = 1,,,,,,,20,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "uaspstor.sys = 1,,,,,,4_,4,0,0,,1,4" -once
FindStr /i /r "usbd8.sys.*,." "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "usbd8.sys = 1,,,,,,4_,4,0,0,,1,4" -once
FindStr /i /r "wpprecor.sys.*,." "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "wpprecor.sys = 1,,,,,,4_,4,0,0,,1,4" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "uaspstor.sys =16" -once
FindStr /i /r "usbd8.sys.*=*16$" "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "usbd8.sys =16" -once
FindStr /i /r "wpprecor.sys.*=*16$" "%TempDir%\TXTSETUP.SIF" >NUL || ".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "FileFlags" -l "wpprecor.sys =16" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\uaspstor.inf" -s "SourceDisksNames" -l "1=\"USB Attached SCSI (UAS) Compatible Device\",,,\"\I386\"" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\uaspstor.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\uaspstor.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbd8.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\wpprecor.sys" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optLUSB%"=="%off%" GoTo SKIP
ECHO.
ECHO ----------------------------------[ Live USB ]---------------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\usb.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\usbport.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\usbstor.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\wmdm.in_" -y -o"%TempDir%\" -bso0 -bsp0
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\usb.inf" > "%TempDir%\usb.utf8.inf"
MOVE /y "%TempDir%\usb.utf8.inf" "%TempDir%\usb.inf" 1>NUL
TYPE "%TempDir%\usbport.inf" > "%TempDir%\usbport.utf8.inf"
MOVE /y "%TempDir%\usbport.utf8.inf" "%TempDir%\usbport.inf" 1>NUL
TYPE "%TempDir%\usbstor.inf" > "%TempDir%\usbstor.utf8.inf"
MOVE /y "%TempDir%\usbstor.utf8.inf" "%TempDir%\usbstor.inf" 1>NUL
TYPE "%TempDir%\wmdm.inf" > "%TempDir%\wmdm.utf8.inf"
MOVE /y "%TempDir%\wmdm.utf8.inf" "%TempDir%\wmdm.inf" 1>NUL
TYPE "%TempDir%\HIVESYS.INF" > "%TempDir%\HIVESYS.utf8.INF"
MOVE /y "%TempDir%\HIVESYS.utf8.INF" "%TempDir%\HIVESYS.INF" 1>NUL
ECHO.
ECHO Changing entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbstor  = usbstor.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbhub   = usbhub.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbuhci  = usbuhci.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbohci  = usbohci.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbehci  = usbehci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "usbstor  = usbstor.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "usbhub   = usbhub.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "usbuhci  = usbuhci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "usbohci  = usbohci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "usbehci  = usbehci.sys" -once
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "usbstor  = \".*\",files.usbstor,usbstor\r\n" -r ""
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "usbhub   = \".*\",files.usbhub,usbhub\r\n" -r ""
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "usbuhci  = \".*\",files.usbuhci,usbuhci\r\n" -r ""
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "usbohci  = \".*\",files.usbohci,usbohci\r\n" -r ""
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "usbehci  = \".*\",files.usbehci,usbehci\r\n" -r ""
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "usbstor  = \"USB Storage Class Driver\",files.usbstor,usbstor" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "usbhub   = \"Generic USB Hub Driver\",files.usbhub,usbhub" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "usbuhci  = \"Universal Host Controller\",files.usbuhci,usbuhci" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "usbohci  = \"Open Host Controller\",files.usbohci,usbohci" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "usbehci  = \"Enhanced Host Controller\",files.usbehci,usbehci" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usb.inf" -s "StandardHub.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usb.inf" -s "StandardHub.AddService" -l "LoadOrderGroup = Base" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usb.inf" -s "StandardHub.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usb.inf" -s "StandardHub.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usb.inf" -s "CommonClassParent.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usb.inf" -s "CommonClassParent.AddService" -l "LoadOrderGroup = Base" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usb.inf" -s "CommonClassParent.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usb.inf" -s "CommonClassParent.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "EHCI.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "EHCI.AddService" -l "LoadOrderGroup = Base" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "EHCI.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "EHCI.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "OHCI.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "OHCI.AddService" -l "LoadOrderGroup = Base" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "OHCI.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "OHCI.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "UHCI.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "UHCI.AddService" -l "LoadOrderGroup = Base" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "UHCI.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "UHCI.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "ROOTHUB.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbport.inf" -s "ROOTHUB.AddService" -l "LoadOrderGroup = Base" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "ROOTHUB.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbport.inf" -s "ROOTHUB.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "StartType      = 3" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "StartType      = 0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "Tag            = 3" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
If Not Exist "%CompileDir%\I386\usbhub3.sy_" GoTo NEXT
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "usbhub3  = usbhub3.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI.Load" -l "usbxhci  = usbxhci.sys,4" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "usbxhci  = \"USB 3.X Host Controller\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SCSI" -l "usbhub3  = \"USB 3.X Hub Driver\"" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "wdf01000 = wdf01000.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "BusExtenders.Load" -l "ucx01000 = ucx01000.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbhub3  = usbhub3.sys" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "InputDevicesSupport.Load" -l "usbxhci  = usbxhci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "usbhub3  = usbhub3.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "usbxhci  = usbxhci.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "ucx01000 = ucx01000.sys" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders.Load" -l "wdf01000 = wdf01000.sys" -once
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "usbhub3  = \".*\",files.usbhub3,usbhub3\r\n" -r ""
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "usbxhci  = \".*\",files.usbxhci,usbxhci\r\n" -r ""
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "ucx01000 = \".*\",files.ucx01000,ucx01000\r\n" -r ""
".\Tools\rxrepl.exe" -f "%TempDir%\TXTSETUP.SIF" -a -m line --no-backup -s "wdf01000 = \".*\",files.wdf01000,wdf01000\r\n" -r ""
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "usbhub3  = \"USB 3.X Hub Driver\",files.usbhub3,usbhub3" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "usbxhci  = \"USB 3.X Host Controller\",files.usbxhci,usbxhci" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "ucx01000 = \"USB 3.X Controller Extension\",files.ucx01000,ucx01000" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "BootBusExtenders" -l "wdf01000 = \"Kernel-Mode Driver Framework 1.11\",files.wdf01000,wdf01000" -once
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Ucx01000\",\"Start\",0x00010003,\"0\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Ucx01000\",\"Start\",0x00010001,\"0\"r\n"
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Ucx01000\",\"Group\",0x00000000,\"Input Device Support\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Ucx01000\",\"Group\",0x00000000,,\"Boot Bus Extender\"r\n"
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBHUB3\",\"Start\",0x00010003,\"0\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBHUB3\",\"Start\",0x00010001,\"0\"r\n"
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBHUB3\",\"Group\",0x00000000,\"Input Device Support\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBHUB3\",\"Group\",0x00000000,,\"Base\"r\n"
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBXHCI\",\"Start\",0x00010003,\"0\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBXHCI\",\"Start\",0x00010001,\"0\"r\n"
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBXHCI\",\"Group\",0x00000000,\"Input Device Support\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\USBXHCI\",\"Group\",0x00000000,,\"Base\"r\n"
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Wdf01000\",\"Start\",0x00010003,\"0\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Wdf01000\",\"Start\",0x00010001,\"0\"r\n"
".\Tools\rxrepl.exe" -f "%TempDir%\HIVESYS.INF" -a -m line --no-backup -s "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Wdf01000\",\"Group\",0x00000000,\"Input Device Support\"r\n" -r "HKLM,\"SYSTEM\\CurrentControlSet\\Services\\Wdf01000\",\"Group\",0x00000000,,\"System Reserved\"r\n"
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "Tag            = 3" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "Tag            = 0" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbstor.inf" -s "USBSTOR.AddService" -l "LoadOrderGroup = System Reserved" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbxhci.inf" -s "Generic.AddService" -l "StartType      = 3" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbxhci.inf" -s "Generic.AddService" -l "StartType      = 0" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbxhci.inf" -s "UCX.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbxhci.inf" -s "UCX.AddService" -l "LoadOrderGroup = Base" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbxhci.inf" -s "UCX.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbxhci.inf" -s "UCX.AddService" -l "LoadOrderGroup = Boot Bus Extender" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\usbhub3.inf" -s "GenericHub.AddService" -l "StartType      = 3                  ; SERVICE_DEMAND_START" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\usbhub3.inf" -s "GenericHub.AddService" -l "StartType      = 0                  ; SERVICE_BOOT_START" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\wmdm.inf" -s "KmdfSvc_Install" -l "LoadOrderGroup=WdfLoadGroup" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\wmdm.inf" -s "KmdfSvc_Install" -l "LoadOrderGroup=System Reserved" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\wmdm.inf" -s "KmdfSvc_Registry" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Wdf01000\",\"Start\",0x00010001,\"0\"" -once
:NEXT
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbstor\",\"DisplayName\",0x00000000,\"USB Mass Storage Driver\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbstor\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbstor\",\"Group\",0x00000000,\"System Reserved\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbstor\",\"ImagePath\",0x00020000,\"system32\drivers\usbstor.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbstor\",\"Start\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbstor\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbehci\",\"DisplayName\",0x00000000,\"USB 2.0 Enhanced Host Controller MiniportDriver\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbehci\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbehci\",\"Group\",0x00000000,\"System Reserved\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbehci\",\"ImagePath\",0x00020000,\"system32\drivers\usbehci.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbehci\",\"Start\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbehci\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbhub\",\"DisplayName\",0x00000000,\"USB2 Enabled Hub\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbhub\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbhub\",\"Group\",0x00000000,\"System Reserved\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbhub\",\"ImagePath\",0x00020000,\"system32\drivers\usbhub.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbhub\",\"Start\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbhub\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbuhci\",\"DisplayName\",0x00000000,\"Microsoft USB Universal Host Controller Miniport Driver\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbuhci\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbuhci\",\"Group\",0x00000000,\"System Reserved\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbuhci\",\"ImagePath\",0x00020000,\"system32\drivers\usbuhci.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbuhci\",\"Start\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbuhci\",\"Type\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbohci\",\"DisplayName\",0x00000000,\"Microsoft USB Open Host Controller Miniport Driver\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbohci\",\"ErrorControl\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbohci\",\"Group\",0x00000000,\"System Reserved\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbohci\",\"ImagePath\",0x00020000,\"system32\drivers\usbohci.sys\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbohci\",\"Start\",0x00010001,\"0\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbohci\",\"Type\",0x00010001,\"1\"" -once
If Not Exist "%CompileDir%\I386\usbhub3.sy_" GoTo NEXT
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Wdf01000\",\"Tag\",0x00010001,\"1\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\usbstor\",\"Tag\",0x00010001,\"2\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\Ucx01000\",\"Tag\",0x00010001,\"3\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBXHCI\",\"Tag\",0x00010001,\"4\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESYS.INF" -s "AddReg" -l "HKLM,\"SYSTEM\CurrentControlSet\Services\USBHUB3\",\"Tag\",0x00010001,\"5\"" -once
:NEXT
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\usb.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbport.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbstor.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbhub3.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\usbxhci.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\wmdm.inf" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESYS.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optACPI%"=="%off%" GoTo SKIP
ECHO.
ECHO --------------------------------[ ACPI Patch ]---------------------------------
ECHO.
ECHO INFO: You can try out different ACPI drivers from the "Patches" folder.
ECHO.
ECHO Copying "acpi.sys" file into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY ".\Patches\ACPI drivers\acpi.sys" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Replacing "acpi.sys" file in the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%TempDir%\acpi.sys" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
".\Tools\makecab.exe" "%TempDir%\acpi.sys" /L "%CompileDir%\I386" 1>NUL
:SKIP

If "%optAVX%"=="%off%" GoTo SKIP
ECHO.
ECHO -------------------------[ AVX/AVX2 256-bit Enabler ]--------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%TempDir%\%WCF%-cab\ntkrpamp.exe" "%TempDir%\" /V /Y /Z 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\SVCPACK.IN_" -y -o"%TempDir%\" -bso0 -bsp0
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\svcpack.inf" > "%TempDir%\svcpack.utf8.inf"
MOVE /y "%TempDir%\svcpack.utf8.inf" "%TempDir%\svcpack.inf" 1>NUL
ECHO.
ECHO Executing AVX Patcher . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\AVX&AVX2 Enabler*"
".\xdelta3.exe" -f -d -s "%TempDir%\ntkrpamp.exe" ".\ntkrpamp.delta" "%TempDir%\ntkrpamp_avx.exe"
PushD "%~dp0"
ping -n 2 localhost 1>NUL
MOVE /y "%TempDir%\ntkrpamp_avx.exe" "%TempDir%\ntkrpamp.exe" 1>NUL
ECHO.
ECHO Editing entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
FindStr /i /c:"CatalogSubDir=\"i386\\hotfixes\"" "%TempDir%\svcpack.inf" >NUL || GoTo NEXT
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "BuildNumber=2600" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MinorVersion=1" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MajorVersion=5" -once
".\Tools\rxrepl.exe" -f "%TempDir%\svcpack.inf" -a -m line --no-backup -s "CatalogSubDir.*\"\r\n" -r "CatalogSubDir=\"\\I386\\svcpack\"\r\n"
:NEXT
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "SP2.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB2862330.CAT" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "SP2.CAT" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB2862330.CAT" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%TempDir%\ntkrpamp.exe" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY ".\Patches\Miscellaneous\Win2003\KB2862330\usbd.sys" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY ".\Patches\Miscellaneous\Win2003\KB2862330\usbport.sys" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY ".\Patches\Miscellaneous\Win2003\SP2 RTM\usbstor.sys" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\SP2 RTM\SP2.CAT" /L "%CompileDir%\I386\SVCPACK" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\SP2 RTM\usbstor.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\KB2862330\KB2862330.CAT" /L "%CompileDir%\I386\SVCPACK" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\KB2862330\usbd.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\KB2862330\usbport.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\svcpack.inf" /L "%CompileDir%\I386" 1>NUL
:SKIP

If "%optPAE4%"=="%off%" GoTo SKIP
ECHO.
ECHO -----------------------------[ PAE 4GB RAM Patch ]-----------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%TempDir%\%WCF%-cab\ntkrnlpa.exe" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\ntkrpamp.exe" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\hal.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halaacpi.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halacpi.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halapic.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halmacpi.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halmps.dll" "%TempDir%\" /V /Y /Z 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\SVCPACK.IN_" -y -o"%TempDir%\" -bso0 -bsp0
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\svcpack.inf" > "%TempDir%\svcpack.utf8.inf"
MOVE /y "%TempDir%\svcpack.utf8.inf" "%TempDir%\svcpack.inf" 1>NUL
ECHO.
ECHO Executing PAE Patcher . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\PAE 3.5+ RAM Unlock*"
START "" /Wait /d "%TempDir%\" ".\WinXP-PAE-Patch.exe" /M:4GB /NB
PushD "%~dp0"
ECHO.
ECHO Editing entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
FindStr /i /c:"CatalogSubDir=\"i386\\hotfixes\"" "%TempDir%\svcpack.inf" >NUL || GoTo NEXT
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "BuildNumber=2600" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MinorVersion=1" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MajorVersion=5" -once
".\Tools\rxrepl.exe" -f "%TempDir%\svcpack.inf" -a -m line --no-backup -s "CatalogSubDir.*\"\r\n" -r "CatalogSubDir=\"\\I386\\svcpack\"\r\n"
:NEXT
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB2862330.CAT" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB2862330.CAT" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%TempDir%\ntkrnlpa.exe" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\ntkrpamp.exe" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\hal.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halaacpi.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halacpi.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halapic.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halmacpi.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halmps.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY ".\Patches\Miscellaneous\Win2003\KB2862330\usbport.sys" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
".\Tools\makecab.exe" "%TempDir%\hal.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halaacpi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halacpi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halapic.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halmacpi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halmps.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\KB2862330\KB2862330.CAT" /L "%CompileDir%\I386\SVCPACK" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\KB2862330\usbport.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\svcpack.inf" /L "%CompileDir%\I386" 1>NUL
:SKIP

If "%optPAE128%"=="%off%" GoTo SKIP
ECHO.
ECHO ----------------------------[ PAE 128GB RAM Patch ]----------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%TempDir%\%WCF%-cab\ntkrnlpa.exe" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\ntkrpamp.exe" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\hal.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halaacpi.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halacpi.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halapic.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halmacpi.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\%WCF%-cab\halmps.dll" "%TempDir%\" /V /Y /Z 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\SVCPACK.IN_" -y -o"%TempDir%\" -bso0 -bsp0
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\svcpack.inf" > "%TempDir%\svcpack.utf8.inf"
MOVE /y "%TempDir%\svcpack.utf8.inf" "%TempDir%\svcpack.inf" 1>NUL
ECHO.
ECHO Executing PAE Patcher . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\PAE 3.5+ RAM Unlock*"
START "" /Wait /d "%TempDir%\" ".\WinXP-PAE-Patch.exe" /M:128GB /NB
PushD "%~dp0"
ECHO.
ECHO Editing entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
FindStr /i /c:"CatalogSubDir=\"i386\\hotfixes\"" "%TempDir%\svcpack.inf" >NUL || GoTo NEXT
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "BuildNumber=2600" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MinorVersion=1" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MajorVersion=5" -once
".\Tools\rxrepl.exe" -f "%TempDir%\svcpack.inf" -a -m line --no-backup -s "CatalogSubDir.*\"\r\n" -r "CatalogSubDir=\"\\I386\\svcpack\"\r\n"
:NEXT
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB2862330.CAT" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB2862330.CAT" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%TempDir%\ntkrnlpa.exe" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\ntkrpamp.exe" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\hal.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halaacpi.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halacpi.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halapic.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halmacpi.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\halmps.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY ".\Patches\Miscellaneous\Win2003\KB2862330\usbport.sys" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
".\Tools\makecab.exe" "%TempDir%\hal.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halaacpi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halacpi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halapic.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halmacpi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\halmps.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\KB2862330\KB2862330.CAT" /L "%CompileDir%\I386\SVCPACK" 1>NUL
".\Tools\makecab.exe" ".\Patches\Miscellaneous\Win2003\KB2862330\usbport.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\svcpack.inf" /L "%CompileDir%\I386" 1>NUL
:SKIP

If "%optTF%"=="%off%" GoTo SKIP
ECHO.
ECHO -----------------------------[ PM/RTC Timer Fix ]------------------------------
ECHO.
Echo %optPAE4% %optPAE128% | FindStr /l /i "%on%" >NUL 2>&1 && Set "PAEO=yes"
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
PushD ".\Patches\Timer Fix*"
If Not "%PAEO%"=="yes" XCOPY ".\PM\halmacpi.dll" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\PM\intelppm.sys" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY ".\RTC\TimerFix.exe" "%TempDir%\" /V /Y /Z 1>NUL
PushD "%~dp0"
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESFT.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\HIVESFT.INF" > "%TempDir%\HIVESFT.utf8.INF"
MOVE /y "%TempDir%\HIVESFT.utf8.INF" "%TempDir%\HIVESFT.INF" 1>NUL
ECHO.
ECHO Adding entries to the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
".\Tools\Fedit.exe" -add -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,TimerFix.exe" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\HIVESFT.INF" -s "AddReg" -l "HKLM,\"SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnceEx\OPI\",\"RTC Timer Fix\",0x00000000,\"CMD /C SCHTASKS /Create /RU SYSTEM /SC ONSTART /TN \"\"RTC Timer Fix\"\" /TR \"\"%%SystemRoot%%\system32\TimerFix.exe\"\" ^& SCHTASKS /Run /TN \"\"RTC Timer Fix\"\"\"" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles.x86" -l "TimerFix.exe = 1,,,,,,,2,0,0" -once
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
If Not "%PAEO%"=="yes" XCOPY "%TempDir%\halmacpi.dll" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\intelppm.sys" "%TempDir%\%WCF%-cab\" /V /Y /Z 1>NUL
If Not "%PAEO%"=="yes" ".\Tools\makecab.exe" "%TempDir%\halmacpi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\intelppm.sys" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\TimerFix.exe" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\HIVESFT.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP

If "%optSSE2%"=="%off%" GoTo SKIP
For /f "tokens=*" %%a in ('Dir /b /s /a:d ".\Patches\SSE2 Updates Rollback*"') do Set "SUR-Dir=%%a"
ECHO.
ECHO ---------------------------[ SSE2 Updates Remover ]----------------------------
ECHO.
ECHO Copying files into the temporary folder . . .
ping -n 3 localhost 1>NUL
XCOPY "%SUR-Dir%\winxpup.inf" "%TempDir%\" /V /Y /Z 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\SVCPACK.IN_" -y -o"%TempDir%\" -bso0 -bsp0
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
ECHO.
ECHO Converting Windows XP Setup source text files into UTF-8 format . . .
TYPE "%TempDir%\svcpack.inf" > "%TempDir%\svcpack.utf8.inf"
MOVE /y "%TempDir%\svcpack.utf8.inf" "%TempDir%\svcpack.inf" 1>NUL
ECHO.
ECHO Editing entries in the Windows XP Setup source files . . .
ping -n 3 localhost 1>NUL
FindStr /i /c:"CatalogSubDir=\"i386\\hotfixes\"" "%TempDir%\svcpack.inf" >NUL || GoTo NEXT
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "BuildNumber=2600" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MinorVersion=1" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "Version" -l "MajorVersion=5" -once
".\Tools\rxrepl.exe" -f "%TempDir%\svcpack.inf" -a -m line --no-backup -s "CatalogSubDir.*\"\r\n" -r "CatalogSubDir=\"\\I386\\svcpack\"\r\n"
:NEXT
".\Tools\Fedit.exe" -rem -f "%TempDir%\DOSNET.INF" -s "Files" -l "d1,msjtes45.dll" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "msjtes40.dll = 100,,,,,,,2,0,0" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "msjtes40.dll = 100,,,,,,,2,0,0" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "msjtes40.dll = 100,,,,,,,2,0,0,msjtes4s.dll" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\TXTSETUP.SIF" -s "SourceDisksFiles" -l "msjtes45.dll= 100,,,,,,,2,0,0,msjtes40.dll" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB954193.CAT" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB3072630.CAT" -once
".\Tools\Fedit.exe" -add -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4012583.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4034775.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4473077.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4489977.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4493793.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4493794.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4493795.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4493796.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4493797.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4494528.CAT" -once
".\Tools\Fedit.exe" -rem -f "%TempDir%\svcpack.inf" -s "ProductCatalogsToInstall" -l "KB4495022.CAT" -once
ECHO.
ECHO Replacing files in the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\asms\10\msft\windows\gdiplus\gdiplus.cat" /L "%CompileDir%\I386\ASMS\10\MSFT\WINDOWS\GDIPLUS" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\asms\10\msft\windows\gdiplus\gdiplus.dll" /L "%CompileDir%\I386\ASMS\10\MSFT\WINDOWS\GDIPLUS" 1>NUL
XCOPY "%SUR-Dir%\asms\10\msft\windows\gdiplus\gdiplus.man" "%CompileDir%\I386\ASMS\10\MSFT\WINDOWS\GDIPLUS\" /V /Y /Z 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\asms\10\policy\msft\windows\gdiplus\gdiplus.cat" /L "%CompileDir%\I386\ASMS\10\POLICY\MSFT\WINDOWS\GDIPLUS" 1>NUL
XCOPY "%SUR-Dir%\asms\10\policy\msft\windows\gdiplus\gdiplus.man" "%CompileDir%\I386\ASMS\10\POLICY\MSFT\WINDOWS\GDIPLUS\" /V /Y /Z 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\gdi32.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\mf3216.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msexcl40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msi.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msiexec.exe" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msihnd.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msjet40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msjetol1.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msjint40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msjter40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msjtes40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msltus40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\mspbde40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msrd2x40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msrd3x40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msrepl40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\mstext40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\mswdat10.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\mswstr10.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msxbde40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\msxbde40.dll" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\winxpup.inf" /L "%CompileDir%\I386" 1>NUL
ECHO.
ECHO Deleting files in the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
DEL /f "%CompileDir%\I386\msjtes45.dl_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4034775.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4473077.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4489977.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4493793.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4493794.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4493795.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4493796.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4493797.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4494528.CA_" 2>NUL
DEL /f "%CompileDir%\I386\SVCPACK\KB4495022.CA_" 2>NUL
ECHO.
ECHO Adding files into the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\svcpack\KB954193.CAT" /L "%CompileDir%\I386\SVCPACK" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\svcpack\KB3072630.CAT" /L "%CompileDir%\I386\SVCPACK" 1>NUL
".\Tools\makecab.exe" "%SUR-Dir%\svcpack\KB4012583.CAT" /L "%CompileDir%\I386\SVCPACK" 1>NUL
".\Tools\makecab.exe" "%TempDir%\svcpack.inf" /L "%CompileDir%\I386" 1>NUL
".\Tools\makecab.exe" "%TempDir%\winxpup.inf" /L "%CompileDir%\I386" 1>NUL
XCOPY "%TempDir%\DOSNET.INF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
XCOPY "%TempDir%\TXTSETUP.SIF" "%CompileDir%\I386\" /V /Y /Z 1>NUL
:SKIP


ECHO.
ECHO --------------------------------[ Final Steps ]--------------------------------
If Not Exist "%CompileDir%\I386\%WCF%.cab" GoTo SKIP
ECHO.
ECHO Compressing %WCF%.cab file, Please wait . . .
ping -n 3 localhost 1>NUL
".\Tools\cabarc.exe" -m LZX:21 N "%CompileDir%\I386\%WCF%.cab" "%TempDir%\%WCF%-cab\*" 1>NUL
If "%ERRORLEVEL%" NEQ "0" ECHO Errors were reported during process. & Pause & GoTo END
:SKIP

Set "CFN=9-WXPIE"
If Not Exist "%CompileDir%\I386\%CFN%.ca_" GoTo SKIP
ECHO.
ECHO Copying modified files into the temporary folder for digital signing . . .
ping -n 3 localhost 1>NUL
If Not Exist "%CompileDir%\I386\SETUP.ORG" GoTo NEXT
XCOPY "%CompileDir%\I386\DOSNET.ORG" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\SETUP.ORG" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\TXTSETUP.ORG" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\WINNT.ORG" "%TempDir%\" /V /Y /Z 1>NUL
:NEXT
If Not Exist "%CompileDir%\I386\ADPU160M.ORG" GoTo NEXT
".\Tools\7z.exe" x "%CompileDir%\I386\ADPU160M.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\DAC2W2K.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\DAC960NT.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\DPTI2O.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\MRAID35X.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\PERC2.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\QL12160.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\SYM_HI.ORG" -y -o"%TempDir%\" -bso0 -bsp0
::".\Tools\7z.exe" x "%CompileDir%\I386\SYMC8XX.ORG" -y -o"%TempDir%\" -bso0 -bsp0
::".\Tools\7z.exe" x "%CompileDir%\I386\SYMC810.ORG" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\ULTRA.ORG" -y -o"%TempDir%\" -bso0 -bsp0
::".\Tools\7z.exe" x "%CompileDir%\I386\VIAIDE.ORG" -y -o"%TempDir%\" -bso0 -bsp0
:NEXT
".\Tools\7z.exe" x "%CompileDir%\I386\accessor.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\AddOnRes.dl_" -y -o"%TempDir%\" -bso0 -bsp0 -bse0
".\Tools\7z.exe" x "%CompileDir%\I386\calc.ch_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\calcplus.ch_" -y -o"%TempDir%\" -bso0 -bsp0 -bse0
".\Tools\7z.exe" x "%CompileDir%\I386\dmadmin.ex_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\DMBOOT.SY_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\dmboot.sy_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\dmconfig.dl_" -y -o"%TempDir%\" -bso0 -bsp0
XCOPY "%CompileDir%\I386\DOSNET.INF" "%TempDir%\" /V /Y /Z 1>NUL
If Exist "%CompileDir%\I386\SP3.CAB" (XCOPY "%CompileDir%\I386\SP3.CAB" "%TempDir%\" /V /Y /Z 1>NUL) Else (XCOPY "%CompileDir%\I386\DRIVER.CAB" "%TempDir%\" /V /Y /Z 1>NUL)
XCOPY "%CompileDir%\I386\drvindex.inf" "%TempDir%\" /V /Y /Z 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\flpydisk.sy_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\font.in_" -y -o"%TempDir%\" -bso0 -bsp0
PushD ".\Extras\Paragon GPT Loader*" 2>NUL
XCOPY ".\gptmount.inf" "%TempDir%\" /V /Y /Z >NUL 2>&1
XCOPY ".\gptmount.sys" "%TempDir%\" /V /Y /Z >NUL 2>&1
PushD "%~dp0"
XCOPY "%CompileDir%\I386\HIVECLS.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVEDEF.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESFT.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVESYS.INF" "%TempDir%\" /V /Y /Z 1>NUL
XCOPY "%CompileDir%\I386\HIVEUSD.INF" "%TempDir%\" /V /Y /Z 1>NUL
::".\Tools\7z.exe" x "%CompileDir%\I386\ie.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\ieaccess.in_" -y -o"%TempDir%\" -bso0 -bsp0
XCOPY "%CompileDir%\I386\intl.inf" "%TempDir%" /V /Y 1>NUL
XCOPY "%CompileDir%\I386\LAYOUT.INF" "%TempDir%" /V /Y 1>NUL
::::".\Tools\7z.exe" x "%CompileDir%\I386\mapi32.dl_" -y -o"%TempDir%\" -bso0 -bsp0
::::".\Tools\7z.exe" x "%CompileDir%\I386\mapistub.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\mdac.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\MSHDC.IN_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\nlite.in_" -y -o"%TempDir%\" -bso0 -bsp0 -bse0
XCOPY "%CompileDir%\I386\NTDETECT.COM" "%TempDir%\" /V /Y /Z 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\PNPSCSI.IN_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\qmgr.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\rootsupd.ex_" -y -o"%TempDir%\" -bso0 -bsp0 -bse0
".\Tools\7z.exe" x "%CompileDir%\I386\rvkroots.ex_" -y -o"%TempDir%\" -bso0 -bsp0 -bse0
".\Tools\7z.exe" x "%CompileDir%\I386\SCSI.IN_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\SCSIDEV.IN_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\services._" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\sfc_os.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\sfcfiles.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\shell.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\shell32.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\shl_img.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\shlwapi.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\sndrec32.ex_" -y -o"%TempDir%\" -bso0 -bsp0
PushD "%CompileDir%\OEM\RunOnce\Programs\Take Ownership XP*" 2>NUL
XCOPY ".\subinacl.exe" "%TempDir%\" /V /Y /Z >NUL 2>&1
PushD "%~dp0"
".\Tools\7z.exe" x "%CompileDir%\I386\svcpack.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\sysoc.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\syssetup.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\syssetup.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\tcpip.sy_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\termsrv.dl_" -y -o"%TempDir%\" -bso0 -bsp0
PushD "%CompileDir%\OEM\RunOnce\Programs\Toshiba UDF*" 2>NUL
XCOPY ".\thdudf.inf" "%TempDir%\" /V /Y /Z >NUL 2>&1
XCOPY ".\thdudf.sys" "%TempDir%\" /V /Y /Z >NUL 2>&1
PushD "%~dp0"
".\Tools\7z.exe" x "%CompileDir%\I386\tsoc.in_" -y -o"%TempDir%\" -bso0 -bsp0
XCOPY "%CompileDir%\I386\TXTSETUP.SIF" "%TempDir%\" /V /Y /Z 1>NUL
".\Tools\7z.exe" x "%CompileDir%\I386\user32.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\uxtheme.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\wbemoc.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\webfldrs.ms_" -y -o"%TempDir%\" -bso0 -bsp0
XCOPY "%CompileDir%\I386\WINNT.SIF" "%TempDir%\" /V /Y /Z >NUL 2>&1
".\Tools\7z.exe" x "%CompileDir%\I386\winxpup.in_" -y -o"%TempDir%\" -bso0 -bsp0 -bse0
".\Tools\7z.exe" x "%CompileDir%\I386\wmdm.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\wmfsdk.in_" -y -o"%TempDir%\" -bso0 -bsp0
::".\Tools\7z.exe" x "%CompileDir%\I386\wmp.in_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\wow32.dl_" -y -o"%TempDir%\" -bso0 -bsp0
".\Tools\7z.exe" x "%CompileDir%\I386\wxpiero.cm_" -y -o"%TempDir%\" -bso0 -bsp0 -bse0
XCOPY "%CompileDir%\I386\wxpiero.inf" "%TempDir%\" /V /Y /Z >NUL 2>&1
ECHO.
ECHO Creating Catalog file (%CFN%.cat) . . .
ping -n 3 localhost 1>NUL
MkDir "%TempDir%\catalog" 2>NUL
>"%TempDir%\catalog\%CFN%.cdf" ECHO [CatalogHeader]
>>"%TempDir%\catalog\%CFN%.cdf" ECHO Name=%CFN%.cat
>>"%TempDir%\catalog\%CFN%.cdf" ECHO PublicVersion=0x0000001
>>"%TempDir%\catalog\%CFN%.cdf" ECHO EncodingType=0x00010001
>>"%TempDir%\catalog\%CFN%.cdf" ECHO CATATTR1=0x10010001:OSAttr:2:5.1
>>"%TempDir%\catalog\%CFN%.cdf" ECHO.
>>"%TempDir%\catalog\%CFN%.cdf" ECHO [CatalogFiles]
For /f "delims=" %%a in ('Dir /b /a:-d-h-s "%TempDir%\*"') do (>>"%TempDir%\catalog\%CFN%.cdf" ECHO ^<hash^>%%a=%TempDir%\%%a)
ping -n 2 localhost 1>NUL
PushD "%TempDir%\catalog"
"%BatchDir%\Tools\Signing Tools\MakeCat.exe" ".\%CFN%.cdf" 1>NUL
PushD "%~dp0"
ECHO.
ECHO Digitally Signing Catalog file (%CFN%.cat) . . .
ping -n 2 "digicert.com" >NUL 2>&1 && Set "TimeStampCommand=/t "http://timestamp.digicert.com"" || Set "TimeStampCommand="
".\Tools\Signing Tools\signtool.exe" sign /f ".\Tools\Signing Tools\Certificates\Code-signing Certificate.pfx" /p "zone54.com" /d "All modified files are signed by this catalog file." /du "http://zone54.com" %TimeStampCommand% /v "%TempDir%\catalog\%CFN%.cat" 1>NUL
ECHO.
ECHO Adding Catalog file (%CFN%.cat) to the Windows XP Setup source folder . . .
ping -n 3 localhost 1>NUL
".\Tools\makecab.exe" "%TempDir%\catalog\%CFN%.cat" /L "%CompileDir%\I386" 1>NUL
:SKIP

ECHO.
ECHO Deleting Temporary folder "%TempDir%" . . .
ping -n 3 localhost 1>NUL
RmDir /s /q "%TempDir%" 2>NUL
ECHO.
ECHO Creating new ISO file . . .
ping -n 3 localhost 1>NUL
RmDir /s /q "%CompileDir%\[BOOT]" 2>NUL
If "%optM2SATA%"=="%on%" Set "ops1=1,"
If "%optM2NVMe%"=="%on%" Set "ops2=2,"
If "%optM2USB%"=="%on%" Set "ops3=3,"
If "%optACPI%"=="%on%" Set "ops4=4,"
If "%optPAE4%"=="%on%" Set "ops5=5,"
If "%optPAE128%"=="%on%" Set "ops6=6,"
If "%optAVX%"=="%on%" Set "ops7=7,"
If "%optKMDF%"=="%on%" Set "opsA=A,"
If "%optUAS%"=="%on%" Set "opsB=B,"
If "%optTF%"=="%on%" Set "opsC=C,"
If "%optLUSB%"=="%on%" Set "opsD=D,"
If "%optDPB%"=="%on%" Set "opsE=E,"
If "%optSSE2%"=="%on%" Set "opsF=F,"
If "%optKSATA%"=="%on%" Set "opsG=G,"
If "%optUISATA%"=="%on%" Set "opsH=H,"
If "%optASATA%"=="%on%" Set "opsI=I,"
If "%optSNVMe%"=="%on%" Set "opsJ=J,"
If "%optK3NVMe%"=="%on%" Set "opsK=K,"
If "%optK5NVMe%"=="%on%" Set "opsM=M,"
If "%optA1USB%"=="%on%" Set "opsN=N,"
If "%optA2USB%"=="%on%" Set "opsL=L,"
Set "ops=%ops1%%ops2%%ops3%%ops4%%ops5%%ops6%%ops7%%opsA%%opsB%%opsC%%opsD%%opsE%%opsF%%opsG%%opsH%%opsI%%opsJ%%opsK%%opsM%%opsN%%opsL%"
For /f  "delims==" %%i in ('Dir /b "..\%WinXP%*" 2^>nul') do Set "FileName=%%i"
For /f  "delims==" %%i in ('Dir /b ".\%WinXP%*" 2^>nul') do Set "FileName=%%i"
If Exist "%FileName:~0,-14% (Customized Option; %ops:~0,-1%).iso" DEL /f "%FileName:~0,-14% (Customized Option; %ops:~0,-1%).iso"
ping -n 1 localhost 1>NUL
".\Tools\cdimage.exe" -b".\Tools\Boot-NoEmul.img" -j1 -o -g -m -l"WinXPPx86IE" "%CompileDir%" "%FileName:~0,-14% (Customized Option; %ops:~0,-1%).iso" 1>NUL
ECHO.
ECHO Deleting Compile folder "%CompileDir%" . . .
ping -n 2 localhost 1>NUL
RmDir /s /q "%CompileDir%" 2>NUL

:END
ECHO.
ECHO ---------------------------------[ Finished ]----------------------------------
ECHO.
Pause
EXIT
